/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.scilab.forge.jlatexmath.Box;

public class FramedBox
extends Box {
    protected Box box;
    protected float thickness;
    protected float space;
    private Color line;
    private Color bg;

    public FramedBox(Box box, float thickness, float space) {
        this.box = box;
        this.width = box.width + 2.0f * thickness + 2.0f * space;
        this.height = box.height + thickness + space;
        this.depth = box.depth + thickness + space;
        this.shift = box.shift;
        this.thickness = thickness;
        this.space = space;
    }

    public FramedBox(Box box, float thickness, float space, Color line, Color bg) {
        this(box, thickness, space);
        this.line = line;
        this.bg = bg;
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        Color prev;
        Stroke st = g2.getStroke();
        g2.setStroke(new BasicStroke(this.thickness, 0, 0));
        float th = this.thickness / 2.0f;
        if (this.bg != null) {
            prev = g2.getColor();
            g2.setColor(this.bg);
            g2.fill(new Rectangle2D.Float(x + th, y - this.height + th, this.width - this.thickness, this.height + this.depth - this.thickness));
            g2.setColor(prev);
        }
        if (this.line != null) {
            prev = g2.getColor();
            g2.setColor(this.line);
            g2.draw(new Rectangle2D.Float(x + th, y - this.height + th, this.width - this.thickness, this.height + this.depth - this.thickness));
            g2.setColor(prev);
        } else {
            g2.draw(new Rectangle2D.Float(x + th, y - this.height + th, this.width - this.thickness, this.height + this.depth - this.thickness));
        }
        g2.setStroke(st);
        this.box.draw(g2, x + this.space + this.thickness, y);
    }

    @Override
    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

