/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.monocle.InputDevice;
import com.sun.glass.ui.monocle.LinuxAbsoluteInputCapabilities;
import com.sun.glass.ui.monocle.LinuxArch;
import com.sun.glass.ui.monocle.LinuxEventBuffer;
import com.sun.glass.ui.monocle.LinuxInputProcessor;
import com.sun.glass.ui.monocle.LinuxKeyBits;
import com.sun.glass.ui.monocle.LinuxSystem;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.RunnableProcessor;
import com.sun.glass.ui.monocle.SysFS;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.BitSet;
import java.util.Map;

class LinuxInputDevice
implements Runnable,
InputDevice {
    private LinuxInputProcessor inputProcessor;
    private ReadableByteChannel in;
    private long fd = -1L;
    private File devNode;
    private File sysPath;
    private Map<String, BitSet> capabilities;
    private Map<Integer, LinuxAbsoluteInputCapabilities> absCaps;
    private Map<String, String> udevManifest;
    private final ByteBuffer event;
    private RunnableProcessor runnableProcessor;
    private EventProcessor processor = new EventProcessor();
    private final LinuxEventBuffer buffer;
    private Map<String, String> uevent;
    private static LinuxSystem system = LinuxSystem.getLinuxSystem();

    LinuxInputDevice(File file, File file2, Map<String, String> map) throws IOException {
        this.buffer = new LinuxEventBuffer(LinuxArch.getBits());
        this.event = ByteBuffer.allocateDirect(this.buffer.getEventSize());
        this.devNode = file;
        this.sysPath = file2;
        this.udevManifest = map;
        this.capabilities = SysFS.readCapabilities(file2);
        this.absCaps = LinuxAbsoluteInputCapabilities.getCapabilities(file, this.capabilities.get("abs"));
        this.fd = system.open(file.getPath(), 0);
        if (this.fd == -1L) {
            throw new IOException(system.getErrorMessage() + " on " + file);
        }
        int n = system.IOW(69, 144, 4);
        system.ioctl(this.fd, n, 1L);
        this.runnableProcessor = NativePlatformFactory.getNativePlatform().getRunnableProcessor();
        this.uevent = SysFS.readUEvent(file2);
    }

    LinuxInputDevice(Map<String, BitSet> map, Map<Integer, LinuxAbsoluteInputCapabilities> map2, ReadableByteChannel readableByteChannel, Map<String, String> map3, Map<String, String> map4) {
        this.buffer = new LinuxEventBuffer(32);
        this.event = ByteBuffer.allocateDirect(this.buffer.getEventSize());
        this.capabilities = map;
        this.absCaps = map2;
        this.in = readableByteChannel;
        this.udevManifest = map3;
        this.uevent = map4;
        this.runnableProcessor = NativePlatformFactory.getNativePlatform().getRunnableProcessor();
    }

    void setInputProcessor(LinuxInputProcessor linuxInputProcessor) {
        this.inputProcessor = linuxInputProcessor;
    }

    private void readToEventBuffer() throws IOException {
        if (this.in != null) {
            this.in.read(this.event);
        } else if (this.fd != -1L) {
            int n = this.event.position();
            int n2 = (int)system.read(this.fd, this.event, n, this.event.limit());
            if (n2 == -1) {
                throw new IOException(system.getErrorMessage() + " on " + this.devNode);
            }
            this.event.position(n + n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.inputProcessor == null) {
            System.err.println("Error: no input processor set on " + this.devNode);
            return;
        }
        try {
            while (true) {
                this.readToEventBuffer();
                if (this.event.position() != this.event.limit()) continue;
                this.event.flip();
                LinuxEventBuffer linuxEventBuffer = this.buffer;
                synchronized (linuxEventBuffer) {
                    if (this.buffer.put(this.event) && !this.processor.scheduled) {
                        this.runnableProcessor.invokeLater(this.processor);
                        this.processor.scheduled = true;
                    }
                }
                this.event.rewind();
            }
        }
        catch (IOException | InterruptedException exception) {
            return;
        }
    }

    LinuxEventBuffer getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isQuiet() {
        LinuxEventBuffer linuxEventBuffer = this.buffer;
        synchronized (linuxEventBuffer) {
            return !this.processor.scheduled && !this.buffer.hasData();
        }
    }

    public String toString() {
        return this.devNode == null ? "Robot" : this.devNode.toString();
    }

    BitSet getCapability(String string) {
        return this.capabilities.get(string);
    }

    LinuxAbsoluteInputCapabilities getAbsoluteInputCapabilities(int n) {
        return this.absCaps == null ? null : this.absCaps.get(n);
    }

    String getProduct() {
        return this.uevent.get("PRODUCT");
    }

    @Override
    public boolean isTouch() {
        return "1".equals(this.udevManifest.get("ID_INPUT_TOUCHSCREEN")) || "1".equals(this.udevManifest.get("ID_INPUT_TABLET")) || this.isTouchDeclaredAsMouse();
    }

    private boolean isTouchDeclaredAsMouse() {
        BitSet bitSet;
        BitSet bitSet2;
        return !(!"1".equals(this.udevManifest.get("ID_INPUT_MOUSE")) || (bitSet2 = this.capabilities.get("rel")) != null && (bitSet2.get(0) || bitSet2.get(1)) || (bitSet = this.capabilities.get("abs")) == null || !bitSet.get(0) && !bitSet.get(53) || !bitSet.get(1) && !bitSet.get(54));
    }

    @Override
    public boolean isMultiTouch() {
        if (this.isTouch()) {
            BitSet bitSet = this.capabilities.get("abs");
            if (bitSet == null) {
                return false;
            }
            return bitSet.get(47) || bitSet.get(53) && bitSet.get(54);
        }
        return false;
    }

    @Override
    public boolean isRelative() {
        return "1".equals(this.udevManifest.get("ID_INPUT_MOUSE"));
    }

    @Override
    public boolean is5Way() {
        int n;
        BitSet bitSet = this.capabilities.get("key");
        if (bitSet == null) {
            return false;
        }
        for (n = 0; n < LinuxKeyBits.KEYBITS_ARROWS.length; ++n) {
            if (bitSet.get(LinuxKeyBits.KEYBITS_ARROWS[n])) continue;
            return false;
        }
        for (n = 0; n < LinuxKeyBits.KEYBITS_SELECT.length; ++n) {
            if (!bitSet.get(LinuxKeyBits.KEYBITS_SELECT[n])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFullKeyboard() {
        BitSet bitSet = this.capabilities.get("key");
        if (bitSet == null) {
            return false;
        }
        for (int i = 0; i < LinuxKeyBits.KEYBITS_PC.length; ++i) {
            if (bitSet.get(LinuxKeyBits.KEYBITS_PC[i])) continue;
            return false;
        }
        return this.is5Way();
    }

    class EventProcessor
    implements Runnable {
        boolean scheduled;

        EventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinuxInputDevice.this.buffer.startIteration();
            try {
                LinuxInputDevice.this.inputProcessor.processEvents(LinuxInputDevice.this);
            }
            catch (RuntimeException runtimeException) {
                Application.reportException(runtimeException);
            }
            LinuxEventBuffer linuxEventBuffer = LinuxInputDevice.this.buffer;
            synchronized (linuxEventBuffer) {
                if (LinuxInputDevice.this.buffer.hasNextEvent()) {
                    LinuxInputDevice.this.runnableProcessor.invokeLater(LinuxInputDevice.this.processor);
                } else {
                    ((LinuxInputDevice)LinuxInputDevice.this).processor.scheduled = false;
                }
                LinuxInputDevice.this.buffer.compact();
            }
        }
    }
}

