/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.Context;
import esmska.data.Icons;
import esmska.data.SMS;
import esmska.gui.GatewayErrorMessage;
import esmska.gui.GatewayImageCodeMessage;
import esmska.gui.GatewayMessage;
import esmska.utils.L10N;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

public class GatewayMessageFrame
extends JFrame {
    private static GatewayMessageFrame instance;
    private static final ResourceBundle l10n;
    private static final Logger logger;
    private int lastPaneRemovedIndex = 0;
    private JScrollPane jScrollPane1;
    private JXTaskPaneContainer taskContainer;

    private GatewayMessageFrame(Frame parent) {
        instance = this;
        this.initComponents();
        this.setLocationRelativeTo(parent);
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(Icons.get("message-16.png").getImage());
        images.add(Icons.get("message-22.png").getImage());
        images.add(Icons.get("message-32.png").getImage());
        images.add(Icons.get("message-48.png").getImage());
        this.setIconImages(images);
        String command = "close";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), command);
        this.getRootPane().getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GatewayMessageFrame.this.close();
            }
        });
        this.taskContainer.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                this.containersChanged();
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                this.containersChanged();
            }

            private void containersChanged() {
                GatewayMessageFrame.this.expandNextPane();
                GatewayMessageFrame.this.updateVisibility();
            }
        });
    }

    public static GatewayMessageFrame getInstance() {
        if (instance == null) {
            instance = new GatewayMessageFrame(Context.mainFrame);
        }
        return instance;
    }

    public void addErrorMsg(SMS sms) {
        logger.log(Level.FINER, "Adding error message: {0}", sms);
        GatewayErrorMessage gem = new GatewayErrorMessage();
        final TaskPane taskPane = gem.showErrorMsg(sms);
        gem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 0) {
                    GatewayMessageFrame.this.removeTaskPane(taskPane);
                }
            }
        });
        this.taskContainer.add(taskPane);
    }

    public void addImageCodeMsg(SMS sms, final ActionListener callback) {
        logger.log(Level.FINER, "Adding image code message: {0}", sms);
        GatewayImageCodeMessage gicm = new GatewayImageCodeMessage();
        final TaskPane taskPane = gicm.showImageCodeMsg(sms);
        gicm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 0) {
                    GatewayMessageFrame.this.removeTaskPane(taskPane);
                    callback.actionPerformed(e);
                }
            }
        });
        this.taskContainer.add(taskPane);
    }

    private void close() {
        this.formWindowClosing(null);
        this.setVisible(false);
        this.dispose();
        this.lastPaneRemovedIndex = 0;
    }

    private void removeTaskPane(TaskPane taskPane) {
        this.lastPaneRemovedIndex = 0;
        Component[] comps = this.taskContainer.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != taskPane) continue;
            this.lastPaneRemovedIndex = i;
        }
        this.taskContainer.remove(taskPane);
    }

    private void expandNextPane() {
        Component[] comps = this.taskContainer.getComponents();
        if (comps.length <= 0) {
            return;
        }
        TaskPane taskPane = (TaskPane)comps[0];
        if (this.lastPaneRemovedIndex < comps.length) {
            taskPane = (TaskPane)comps[this.lastPaneRemovedIndex];
        }
        taskPane.setCollapsed(false);
        taskPane.getGatewayMessage().setBestFocus();
    }

    private void focusPane() {
        for (Component comp : this.taskContainer.getComponents()) {
            TaskPane taskPane = (TaskPane)comp;
            if (taskPane.isCollapsed()) continue;
            taskPane.getGatewayMessage().setBestFocus();
            break;
        }
    }

    private void updateVisibility() {
        boolean wasVisible = this.isVisible();
        this.setVisible(this.taskContainer.getComponentCount() > 0);
        if (wasVisible && !this.isVisible()) {
            this.close();
        }
        if (!wasVisible && this.isVisible()) {
            logger.finer("Showing GatewayMessageFrame");
            this.focusPane();
            this.toFront();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.taskContainer = new JXTaskPaneContainer();
        this.setDefaultCloseOperation(2);
        this.setTitle(l10n.getString("GatewayMessageFrame.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GatewayMessageFrame.this.formWindowClosing(evt);
            }
        });
        this.jScrollPane1.setBorder(null);
        this.taskContainer.setOpaque(false);
        this.jScrollPane1.setViewportView(this.taskContainer);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 477, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 317, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        logger.finer("Hiding GatewayMessageDialog, cancelling all requests");
        for (Component comp : this.taskContainer.getComponents()) {
            TaskPane taskPane = (TaskPane)comp;
            taskPane.getGatewayMessage().cancel();
        }
    }

    static {
        l10n = L10N.l10nBundle;
        logger = Logger.getLogger(GatewayMessageFrame.class.getName());
    }

    public static class TaskPane
    extends JXTaskPane {
        private GatewayMessage gm;

        public TaskPane(GatewayMessage gm) {
            this.gm = gm;
            this.add(gm);
            String command = "cancel";
            this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), command);
            this.getActionMap().put(command, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TaskPane.this.getGatewayMessage().cancel();
                }
            });
            command = "toggle-collapse";
            this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), command);
            this.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), command);
            this.getActionMap().put(command, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TaskPane.this.setCollapsed(!TaskPane.this.isCollapsed());
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (e.isTemporary()) {
                        return;
                    }
                    TaskPane.this.scrollRectToVisible(new Rectangle(TaskPane.this.getX(), TaskPane.this.getY(), 1, 1));
                }
            });
        }

        public GatewayMessage getGatewayMessage() {
            return this.gm;
        }
    }
}

