/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.WritableByteChannel;

class Framebuffer {
    private ByteBuffer bb;
    private int width;
    private int height;
    private int byteDepth;
    private boolean receivedData;
    private ByteBuffer clearBuffer;
    private ByteBuffer lineByteBuffer;
    private Buffer linePixelBuffer;
    private int address;

    Framebuffer(ByteBuffer byteBuffer, int n, int n2, int n3, boolean bl) {
        this.bb = byteBuffer;
        this.width = n;
        this.height = n2;
        this.byteDepth = n3 >>> 3;
        if (bl) {
            this.clearBuffer = ByteBuffer.allocate(n * 4);
        }
    }

    ByteBuffer getBuffer() {
        this.bb.clear();
        return this.bb;
    }

    void reset() {
        this.receivedData = false;
    }

    void setStartAddress(int n) {
        this.address = n;
    }

    void clearBufferContents() {
        this.bb.clear();
        this.bb.position(this.address);
        this.bb.limit(this.address + this.width * this.height * 4);
        for (int i = 0; i < this.height; ++i) {
            this.clearBuffer.clear();
            this.bb.put(this.clearBuffer);
        }
    }

    boolean hasReceivedData() {
        return this.receivedData;
    }

    void composePixels(Buffer buffer, int n, int n2, int n3, int n4, float f) {
        int n5 = n3 * 4;
        int n6 = 0;
        if (n < 0) {
            n6 -= n * 4;
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n6 -= n2 * n5;
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 = this.width - n;
        }
        if (n2 + n4 > this.height) {
            n4 = this.height - n2;
        }
        int n7 = Math.round(Math.min(f, 1.0f) * 256.0f);
        if (n3 < 0 || n4 < 0 || n7 <= 0) {
            return;
        }
        if (!(this.receivedData || this.clearBuffer == null || n7 >= 256 && n6 == 0 && n3 == this.width && n4 == this.height)) {
            this.clearBufferContents();
        }
        this.bb.position(this.address + n * 4 + n2 * this.width * 4);
        this.bb.limit(this.bb.capacity());
        if (this.receivedData) {
            IntBuffer intBuffer = buffer instanceof IntBuffer ? (IntBuffer)buffer : ((ByteBuffer)buffer).asIntBuffer();
            IntBuffer intBuffer2 = this.bb.asIntBuffer();
            for (int i = 0; i < n4; ++i) {
                int n8;
                int n9 = i * this.width;
                int n10 = n6 + i * n5 >> 2;
                if (n7 >= 255) {
                    for (n8 = 0; n8 < n3; ++n8) {
                        int n11 = intBuffer.get(n10 + n8);
                        int n12 = n11 >> 24 & 0xFF;
                        if (n12 == 255) {
                            intBuffer2.put(n9 + n8, n11);
                            continue;
                        }
                        intBuffer2.put(n9 + n8, Framebuffer.blend32(n11, intBuffer2.get(n9 + n8), 256));
                    }
                    continue;
                }
                for (n8 = 0; n8 < n3; ++n8) {
                    intBuffer2.put(n9 + n8, Framebuffer.blend32(intBuffer.get(n10 + n8), intBuffer2.get(n9 + n8), n7));
                }
            }
        } else if (n3 == this.width) {
            if (buffer instanceof ByteBuffer) {
                buffer.position(n6);
                buffer.limit(n5 * n4);
                this.bb.put((ByteBuffer)buffer);
            } else {
                IntBuffer intBuffer = (IntBuffer)buffer;
                intBuffer.position(n6 >> 2);
                intBuffer.limit(n5 * n4 >> 2);
                this.bb.asIntBuffer().put(intBuffer);
            }
        } else if (buffer instanceof ByteBuffer) {
            for (int i = 0; i < n4; ++i) {
                this.bb.position(this.address + n * 4 + (n2 + i) * this.width * 4);
                buffer.limit(n6 + i * n5 + n3 * 4);
                buffer.position(n6 + i * n5);
                this.bb.put((ByteBuffer)buffer);
            }
        } else {
            this.bb.position(this.address);
            this.bb.limit(this.address + this.width * this.height * 4);
            IntBuffer intBuffer = this.bb.asIntBuffer();
            IntBuffer intBuffer3 = (IntBuffer)buffer;
            for (int i = 0; i < n4; ++i) {
                intBuffer.position(n + (n2 + i) * this.width);
                intBuffer3.limit(n3 + (n6 + i * n5 >> 2));
                intBuffer3.position(n6 + i * n5 >> 2);
                intBuffer.put((IntBuffer)buffer);
            }
        }
        this.receivedData = true;
    }

    private static int blend32(int n, int n2, int n3) {
        int n4 = (n >> 24 & 0xFF) * n3 >> 8;
        int n5 = n >> 16 & 0xFF;
        int n6 = n >> 8 & 0xFF;
        int n7 = n & 0xFF;
        int n8 = n2 >> 24 & 0xFF;
        int n9 = n2 >> 16 & 0xFF;
        int n10 = n2 >> 8 & 0xFF;
        int n11 = n2 & 0xFF;
        n9 = n5 * n4 / 255 + n9 * n8 * (255 - n4) / 65280;
        n10 = n6 * n4 / 255 + n10 * n8 * (255 - n4) / 65280;
        n11 = n7 * n4 / 255 + n11 * n8 * (255 - n4) / 65280;
        n8 = n4 + n8 * (255 - n4) / 255;
        return n8 << 24 | n9 << 16 | n10 << 8 | n11;
    }

    void write(WritableByteChannel writableByteChannel) throws IOException {
        this.bb.clear();
        if (this.byteDepth == 4) {
            writableByteChannel.write(this.bb);
        } else if (this.byteDepth == 2) {
            if (this.lineByteBuffer == null) {
                this.lineByteBuffer = ByteBuffer.allocate(this.width * 2);
                this.lineByteBuffer.order(ByteOrder.nativeOrder());
                this.linePixelBuffer = this.lineByteBuffer.asShortBuffer();
            }
            IntBuffer intBuffer = this.bb.asIntBuffer();
            ShortBuffer shortBuffer = (ShortBuffer)this.linePixelBuffer;
            for (int i = 0; i < this.height; ++i) {
                shortBuffer.clear();
                for (int j = 0; j < this.width; ++j) {
                    int n = intBuffer.get();
                    int n2 = (n >> 19 & 0x1F) * 539219 >> 8 & 0xF800;
                    int n3 = (n >> 10 & 0x3F) * 265395 >> 13 & 0x7E0;
                    int n4 = (n >> 3 & 0x1F) * 539219 >> 19;
                    int n5 = n2 | n3 | n4;
                    shortBuffer.put((short)n5);
                }
                this.lineByteBuffer.clear();
                writableByteChannel.write(this.lineByteBuffer);
            }
        }
    }

    void copyToBuffer(ByteBuffer byteBuffer) {
        this.bb.clear();
        if (this.byteDepth == 4) {
            byteBuffer.put(this.bb);
        } else if (this.byteDepth == 2) {
            if (this.lineByteBuffer == null) {
                this.lineByteBuffer = ByteBuffer.allocate(this.width * 2);
                this.lineByteBuffer.order(ByteOrder.nativeOrder());
                this.linePixelBuffer = this.lineByteBuffer.asShortBuffer();
            }
            IntBuffer intBuffer = this.bb.asIntBuffer();
            ShortBuffer shortBuffer = (ShortBuffer)this.linePixelBuffer;
            for (int i = 0; i < this.height; ++i) {
                shortBuffer.clear();
                for (int j = 0; j < this.width; ++j) {
                    int n = intBuffer.get();
                    int n2 = (n >> 19 & 0x1F) * 539219 >> 8 & 0xF800;
                    int n3 = (n >> 10 & 0x3F) * 265395 >> 13 & 0x7E0;
                    int n4 = (n >> 3 & 0x1F) * 539219 >> 19;
                    int n5 = n2 | n3 | n4;
                    shortBuffer.put((short)n5);
                }
                this.lineByteBuffer.clear();
                byteBuffer.put(this.lineByteBuffer);
            }
        }
    }
}

