/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicToolTipUI;

class ImageToolTipUI
extends BasicToolTipUI {
    private ImageIcon imageIcon;
    private String text = "";
    private static final int GAP = 2;

    public ImageToolTipUI(ImageIcon imageIcon, String text) {
        this.imageIcon = imageIcon;
        if (text != null) {
            this.text = text;
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent c) {
        if (graphics != null) {
            if (this.imageIcon != null) {
                graphics.drawImage(this.imageIcon.getImage(), 0, 0, c);
            } else {
                graphics.setColor(Color.BLACK);
                int ascent = graphics.getFontMetrics().getAscent();
                graphics.drawString(this.text, 2, 2 + ascent);
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.imageIcon != null) {
            return new Dimension(this.imageIcon.getIconWidth(), this.imageIcon.getIconHeight());
        }
        int width = c.getFontMetrics(c.getFont()).stringWidth(this.text);
        int height = c.getFontMetrics(c.getFont()).getHeight();
        return new Dimension(width + 4, height + 4);
    }

    public ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    public void setImageIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
    }
}

