/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.data.Contact;
import esmska.data.event.ActionEventSupport;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;

public class Contacts {
    public static final int ACTION_ADD_CONTACT = 0;
    public static final int ACTION_REMOVE_CONTACT = 1;
    public static final int ACTION_CLEAR_CONTACTS = 2;
    public static final int ACTION_CHANGE_CONTACT = 3;
    private static final Contacts instance = new Contacts();
    private static final Logger logger = Logger.getLogger(Contacts.class.getName());
    private final SortedSet<Contact> contacts = Collections.synchronizedSortedSet(new TreeSet());
    private ContactChangeListener contactChangeListener = new ContactChangeListener();
    private ActionEventSupport actionSupport = new ActionEventSupport(this);

    public void addActionListener(ActionListener actionListener) {
        this.actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionSupport.removeActionListener(actionListener);
    }

    private Contacts() {
    }

    public static Contacts getInstance() {
        return instance;
    }

    public SortedSet<Contact> getAll() {
        return Collections.unmodifiableSortedSet(this.contacts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Contact contact) {
        if (contact == null) {
            throw new IllegalArgumentException("contact");
        }
        logger.fine("Adding new contact: " + contact);
        boolean added = false;
        SortedSet<Contact> sortedSet = this.contacts;
        synchronized (sortedSet) {
            added = this.contacts.add(contact);
            if (added) {
                contact.addPropertyChangeListener(this.contactChangeListener);
            }
        }
        if (added) {
            this.actionSupport.fireActionPerformed(0, null);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<Contact> contacts) {
        if (contacts == null) {
            throw new IllegalArgumentException("contacts");
        }
        logger.fine("Adding " + contacts.size() + " contacts: " + contacts);
        boolean changed = false;
        SortedSet<Contact> sortedSet = this.contacts;
        synchronized (sortedSet) {
            for (Contact contact : contacts) {
                if (this.contacts.contains(contact)) continue;
                contact.addPropertyChangeListener(this.contactChangeListener);
            }
            changed = this.contacts.addAll(contacts);
        }
        if (changed) {
            this.actionSupport.fireActionPerformed(0, null);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Contact contact) {
        if (contact == null) {
            throw new IllegalArgumentException("contact");
        }
        logger.fine("Removing contact: " + contact);
        boolean removed = false;
        SortedSet<Contact> sortedSet = this.contacts;
        synchronized (sortedSet) {
            removed = this.contacts.remove(contact);
            if (removed) {
                contact.removePropertyChangeListener(this.contactChangeListener);
            }
        }
        if (removed) {
            this.actionSupport.fireActionPerformed(1, null);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection<Contact> contacts) {
        if (contacts == null) {
            throw new IllegalArgumentException("contacts");
        }
        logger.fine("Removing " + contacts.size() + " contacts: " + contacts);
        boolean changed = false;
        SortedSet<Contact> sortedSet = this.contacts;
        synchronized (sortedSet) {
            for (Contact contact : contacts) {
                if (!this.contacts.contains(contact)) continue;
                contact.removePropertyChangeListener(this.contactChangeListener);
            }
            changed = this.contacts.removeAll(contacts);
        }
        if (changed) {
            this.actionSupport.fireActionPerformed(1, null);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        logger.fine("Removing all contacts");
        SortedSet<Contact> sortedSet = this.contacts;
        synchronized (sortedSet) {
            for (Contact contact : this.contacts) {
                contact.removePropertyChangeListener(this.contactChangeListener);
            }
            this.contacts.clear();
        }
        this.actionSupport.fireActionPerformed(2, null);
    }

    public boolean contains(Contact contact) {
        if (contact == null) {
            throw new IllegalArgumentException("contact");
        }
        return this.contacts.contains(contact);
    }

    public int size() {
        return this.contacts.size();
    }

    public boolean isEmpty() {
        return this.contacts.isEmpty();
    }

    private class ContactChangeListener
    implements PropertyChangeListener {
        private ContactChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Contacts.this.actionSupport.fireActionPerformed(3, null);
        }
    }
}

