/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.data.Tuple;
import esmska.data.event.ActionEventSupport;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ObjectUtils;

public class Keyring {
    private static final Keyring instance = new Keyring();
    public static final int ACTION_ADD_KEY = 0;
    public static final int ACTION_REMOVE_KEY = 1;
    public static final int ACTION_CLEAR_KEYS = 2;
    private static final Logger logger = Logger.getLogger(Keyring.class.getName());
    private static final byte[] passphrase = new byte[]{-47, 12, -115, -66, 28, 102, 93, 101, -98, -87, 96, -11, -72, 117, -39, 39, 102, 73, -122, 91, -14, -118, 5, -82, -126, 3, 38, -19, -63, -127, 46, -82, 27, -38, -89, 29, 10, 81, -108, 17, -96, -71, 120, 63, -128, -3, -3, -63, 65, -40, 109, 70, 69, -122, 80, -83, 37, -45, 61, 60, -12, -101, 0, -126, 44, -125, -83, 47, -48, -7, 8, 16, 127, 25, -1, -23, 27, -78, 124, 36, 59, 52, -66, 40, -31, -7, 111, -101, -5, 85, -65, -90, -56, -51, 53, 44, 20, 15, 111, 37, -97, 120, -60, 53, -80, 69, 34, 109, -71, 101, -66, 77, 52, -14, 112, 112, 97, 12, -76, -96, -101, 103, -59, 38, -24, -10, -85, -119};
    private final Map<String, Tuple<String, String>> keyring = Collections.synchronizedMap(new HashMap());
    private ActionEventSupport actionSupport = new ActionEventSupport(this);

    public void addActionListener(ActionListener actionListener) {
        this.actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionSupport.removeActionListener(actionListener);
    }

    private Keyring() {
    }

    public static Keyring getInstance() {
        return instance;
    }

    public Tuple<String, String> getKey(String gatewayName) {
        return this.keyring.get(gatewayName);
    }

    public void putKey(String gatewayName, Tuple<String, String> key) {
        if (this.putKeyImpl(gatewayName, key)) {
            logger.finer("New keyring key added: [gatewayName=" + gatewayName + "]");
            this.actionSupport.fireActionPerformed(0, null);
        }
    }

    private boolean putKeyImpl(String gatewayName, Tuple<String, String> key) {
        if (gatewayName == null) {
            throw new IllegalArgumentException("gatewayName");
        }
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        Tuple<String, String> previous = this.keyring.put(gatewayName, key);
        return previous == null || !ObjectUtils.equals(previous, key);
    }

    public void putKeys(Map<String, Tuple<String, String>> keys) {
        int changed = 0;
        for (Map.Entry<String, Tuple<String, String>> entry : keys.entrySet()) {
            changed += this.putKeyImpl(entry.getKey(), entry.getValue()) ? 1 : 0;
        }
        if (changed > 0) {
            logger.finer(changed + " new keyring keys added");
            this.actionSupport.fireActionPerformed(0, null);
        }
    }

    public void removeKey(String gatewayName) {
        if (this.keyring.remove(gatewayName) != null) {
            logger.finer("A keyring key removed: [gatewayName=" + gatewayName + "]");
            this.actionSupport.fireActionPerformed(1, null);
        }
    }

    public Set<String> getGatewayNames() {
        return Collections.unmodifiableSet(this.keyring.keySet());
    }

    public void clearKeys() {
        this.keyring.clear();
        logger.finer("All keyring keys removed");
        this.actionSupport.fireActionPerformed(2, null);
    }

    public static String encrypt(String input) {
        if (input == null) {
            input = "";
        }
        try {
            byte[] inputArray = input.getBytes("UTF-8");
            byte[] encrArray = new byte[inputArray.length * 2];
            for (int i = 0; i < inputArray.length; ++i) {
                byte k = i < passphrase.length ? passphrase[i] : (byte)0;
                encrArray[2 * i] = (byte)(inputArray[i] ^ k);
                encrArray[2 * i + 1] = encrArray[2 * i];
            }
            String encrString = new String(Base64.encodeBase64(encrArray), "US-ASCII");
            return encrString;
        }
        catch (UnsupportedEncodingException ex) {
            assert (false) : "Basic charsets must be supported";
            throw new IllegalStateException("Basic charsets must be supported", ex);
        }
    }

    public static String decrypt(String input) {
        if (input == null) {
            input = "";
        }
        try {
            byte[] encrArray = Base64.decodeBase64(input.getBytes("US-ASCII"));
            byte[] decrArray = new byte[encrArray.length / 2];
            for (int i = 0; i < encrArray.length; i += 2) {
                byte k = i / 2 < passphrase.length ? passphrase[i / 2] : (byte)0;
                decrArray[i / 2] = (byte)(encrArray[i] ^ k);
            }
            String decrString = new String(decrArray, "UTF-8");
            return decrString;
        }
        catch (UnsupportedEncodingException ex) {
            assert (false) : "Basic charsets must be supported";
            throw new IllegalStateException("Basic charsets must be supported", ex);
        }
    }
}

