/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.test;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.Rational;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import java.io.File;
import junit.framework.TestCase;

public class NikonType2MakernoteTest2
extends TestCase {
    private NikonType2MakernoteDirectory _nikonDirectory;
    private ExifDirectory _exifDirectory;

    public NikonType2MakernoteTest2(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        File nikonJpeg = new File("src/com/drew/metadata/exif/test/nikonMakernoteType2b.jpg");
        Metadata metadata = JpegMetadataReader.readMetadata(nikonJpeg);
        this._nikonDirectory = (NikonType2MakernoteDirectory)metadata.getDirectory(NikonType2MakernoteDirectory.class);
        this._exifDirectory = (ExifDirectory)metadata.getDirectory(ExifDirectory.class);
    }

    public void testNikonMakernote_MatchesKnownValues() throws Exception {
        NikonType2MakernoteTest2.assertEquals((String)"0 1 0 0", (String)this._nikonDirectory.getString(1));
        NikonType2MakernoteTest2.assertEquals((String)"0 0", (String)this._nikonDirectory.getString(2));
        NikonType2MakernoteTest2.assertEquals((String)"COLOR", (String)this._nikonDirectory.getString(3));
        NikonType2MakernoteTest2.assertEquals((String)"NORMAL ", (String)this._nikonDirectory.getString(4));
        NikonType2MakernoteTest2.assertEquals((String)"AUTO        ", (String)this._nikonDirectory.getString(5));
        NikonType2MakernoteTest2.assertEquals((String)"AUTO  ", (String)this._nikonDirectory.getString(6));
        NikonType2MakernoteTest2.assertEquals((String)"AF-C  ", (String)this._nikonDirectory.getString(7));
        NikonType2MakernoteTest2.assertEquals((String)"NORMAL      ", (String)this._nikonDirectory.getString(8));
        NikonType2MakernoteTest2.assertEquals((String)"AUTO  ", (String)this._nikonDirectory.getString(15));
        NikonType2MakernoteTest2.assertEquals((int)1300, (int)this._nikonDirectory.getInt(17));
        NikonType2MakernoteTest2.assertEquals((String)"AUTO         ", (String)this._nikonDirectory.getString(128));
        NikonType2MakernoteTest2.assertEquals((String)"OFF         ", (String)this._nikonDirectory.getString(130));
        NikonType2MakernoteTest2.assertEquals((int)0, (int)this._nikonDirectory.getInt(133));
        NikonType2MakernoteTest2.assertEquals((int)1, (int)this._nikonDirectory.getInt(134));
        NikonType2MakernoteTest2.assertEquals((String)"                ", (String)this._nikonDirectory.getString(143));
        NikonType2MakernoteTest2.assertEquals((int)0, (int)this._nikonDirectory.getInt(148));
        NikonType2MakernoteTest2.assertEquals((String)"FPNR", (String)this._nikonDirectory.getString(149));
        NikonType2MakernoteTest2.assertEquals((String)"80 114 105 110 116 73 77 0 48 49 48 48 0 0 13 0 1 0 22 0 22 0 2 0 1 0 0 0 3 0 94 0 0 0 7 0 0 0 0 0 8 0 0 0 0 0 9 0 0 0 0 0 10 0 0 0 0 0 11 0 -90 0 0 0 12 0 0 0 0 0 13 0 0 0 0 0 14 0 -66 0 0 0 0 1 5 0 0 0 1 1 1 0 0 0 9 17 0 0 16 39 0 0 11 15 0 0 16 39 0 0 -105 5 0 0 16 39 0 0 -80 8 0 0 16 39 0 0 1 28 0 0 16 39 0 0 94 2 0 0 16 39 0 0 -117 0 0 0 16 39 0 0 -53 3 0 0 16 39 0 0 -27 27 0 0 16 39 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0", (String)this._nikonDirectory.getString(3584));
        NikonType2MakernoteTest2.assertEquals((int)1394, (int)this._nikonDirectory.getInt(3600));
    }

    public void testExifDirectory_MatchesKnownValues() throws Exception {
        NikonType2MakernoteTest2.assertEquals((String)"          ", (String)this._exifDirectory.getString(270));
        NikonType2MakernoteTest2.assertEquals((String)"NIKON", (String)this._exifDirectory.getString(271));
        NikonType2MakernoteTest2.assertEquals((String)"E995", (String)this._exifDirectory.getString(272));
        NikonType2MakernoteTest2.assertEquals((double)72.0, (double)this._exifDirectory.getDouble(282), (double)0.001);
        NikonType2MakernoteTest2.assertEquals((double)72.0, (double)this._exifDirectory.getDouble(283), (double)0.001);
        NikonType2MakernoteTest2.assertEquals((int)2, (int)this._exifDirectory.getInt(296));
        NikonType2MakernoteTest2.assertEquals((String)"E995v1.6", (String)this._exifDirectory.getString(305));
        NikonType2MakernoteTest2.assertEquals((String)"2002:08:29 17:31:40", (String)this._exifDirectory.getString(306));
        NikonType2MakernoteTest2.assertEquals((int)1, (int)this._exifDirectory.getInt(531));
        NikonType2MakernoteTest2.assertEquals((Object)new Rational(2439024, 100000000), (Object)this._exifDirectory.getRational(33434));
        NikonType2MakernoteTest2.assertEquals((double)2.6, (double)this._exifDirectory.getDouble(33437), (double)0.001);
        NikonType2MakernoteTest2.assertEquals((int)2, (int)this._exifDirectory.getInt(34850));
        NikonType2MakernoteTest2.assertEquals((int)100, (int)this._exifDirectory.getInt(34855));
        NikonType2MakernoteTest2.assertEquals((String)"48 50 49 48", (String)this._exifDirectory.getString(36864));
        NikonType2MakernoteTest2.assertEquals((String)"2002:08:29 17:31:40", (String)this._exifDirectory.getString(36868));
        NikonType2MakernoteTest2.assertEquals((String)"2002:08:29 17:31:40", (String)this._exifDirectory.getString(36867));
        NikonType2MakernoteTest2.assertEquals((String)"1 2 3 0", (String)this._exifDirectory.getString(37121));
        NikonType2MakernoteTest2.assertEquals((int)0, (int)this._exifDirectory.getInt(37380));
        NikonType2MakernoteTest2.assertEquals((String)"0", (String)this._exifDirectory.getString(37381));
        NikonType2MakernoteTest2.assertEquals((int)5, (int)this._exifDirectory.getInt(37383));
        NikonType2MakernoteTest2.assertEquals((int)0, (int)this._exifDirectory.getInt(37384));
        NikonType2MakernoteTest2.assertEquals((int)1, (int)this._exifDirectory.getInt(37385));
        NikonType2MakernoteTest2.assertEquals((double)8.2, (double)this._exifDirectory.getDouble(37386), (double)0.001);
        NikonType2MakernoteTest2.assertEquals((String)"0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32", (String)this._exifDirectory.getString(37510));
        NikonType2MakernoteTest2.assertEquals((String)"48 49 48 48", (String)this._exifDirectory.getString(40960));
        NikonType2MakernoteTest2.assertEquals((int)1, (int)this._exifDirectory.getInt(40961));
        NikonType2MakernoteTest2.assertEquals((int)2048, (int)this._exifDirectory.getInt(40962));
        NikonType2MakernoteTest2.assertEquals((int)1536, (int)this._exifDirectory.getInt(40963));
        NikonType2MakernoteTest2.assertEquals((int)3, (int)this._exifDirectory.getInt(41728));
        NikonType2MakernoteTest2.assertEquals((int)1, (int)this._exifDirectory.getInt(41729));
        NikonType2MakernoteTest2.assertEquals((int)6, (int)this._exifDirectory.getInt(259));
        NikonType2MakernoteTest2.assertEquals((int)1494, (int)this._exifDirectory.getInt(513));
        NikonType2MakernoteTest2.assertEquals((int)6077, (int)this._exifDirectory.getInt(514));
    }
}

