/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.data.Config;
import esmska.data.Contact;
import esmska.data.Contacts;
import esmska.data.DeprecatedGateway;
import esmska.data.Gateway;
import esmska.data.GatewayInfo;
import esmska.data.Keyring;
import esmska.data.Tuple;
import esmska.data.event.ValuedEventSupport;
import esmska.data.event.ValuedListener;
import esmska.utils.L10N;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class Gateways {
    private static final Config config = Config.getInstance();
    private static final Gateways instance = new Gateways();
    private static final Logger logger = Logger.getLogger(Gateways.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final SortedSet<Gateway> gateways = Collections.synchronizedSortedSet(new TreeSet());
    private static final Set<DeprecatedGateway> deprecatedGateways = Collections.synchronizedSet(new HashSet());
    private static final Keyring keyring = Keyring.getInstance();
    private static final ScriptEngineManager manager = new ScriptEngineManager();
    private static final ScriptEngine jsEngine = manager.getEngineByName("js");
    private ValuedEventSupport<Events, Gateway> valuedSupport = new ValuedEventSupport(this);

    public void addValuedListener(ValuedListener<Events, Gateway> valuedListener) {
        this.valuedSupport.addValuedListener(valuedListener);
    }

    public void removeValuedListener(ValuedListener<Events, Gateway> valuedListener) {
        this.valuedSupport.removeValuedListener(valuedListener);
    }

    private Gateways() {
        config.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("favoriteGateways".equals(evt.getPropertyName())) {
                    Gateways.this.updateFavorites();
                }
                if ("hiddenGateways".equals(evt.getPropertyName())) {
                    Gateways.this.updateHidden();
                }
            }
        });
    }

    public static Gateways getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeSet<Gateway> getAll() {
        SortedSet<Gateway> sortedSet = gateways;
        synchronized (sortedSet) {
            TreeSet<Gateway> gws = new TreeSet<Gateway>(gateways);
            return gws;
        }
    }

    public boolean add(Gateway gateway) {
        Validate.notNull(gateway);
        logger.log(Level.FINE, "Adding new gateway: {0}", gateway);
        boolean added = gateways.add(gateway);
        if (added) {
            this.updateFavorites();
            this.updateHidden();
            this.valuedSupport.fireEventOccured(Events.ADDED_GATEWAY, gateway);
        }
        return added;
    }

    public boolean addAll(Collection<Gateway> gateways) {
        Validate.notNull(gateways);
        Validate.noNullElements(gateways);
        logger.log(Level.FINE, "Adding {0} gateways: {1}", new Object[]{gateways.size(), gateways});
        boolean changed = Gateways.gateways.addAll(gateways);
        if (changed) {
            this.updateFavorites();
            this.updateHidden();
            this.valuedSupport.fireEventOccured(Events.ADDED_GATEWAYS, null);
        }
        return changed;
    }

    public boolean remove(Gateway gateway) {
        Validate.notNull(gateway);
        logger.log(Level.FINE, "Removing gateway: {0}", gateway);
        boolean removed = gateways.remove(gateway);
        if (removed) {
            this.valuedSupport.fireEventOccured(Events.REMOVED_GATEWAY, gateway);
        }
        return removed;
    }

    public boolean removeAll(Collection<Gateway> gateways) {
        Validate.notNull(gateways);
        Validate.noNullElements(gateways);
        logger.log(Level.FINE, "Removing {0} gateways: {1}", new Object[]{gateways.size(), gateways});
        boolean changed = Gateways.gateways.removeAll(gateways);
        if (changed) {
            this.valuedSupport.fireEventOccured(Events.REMOVED_GATEWAYS, null);
        }
        return changed;
    }

    public void clear() {
        logger.fine("Removing all gateways");
        gateways.clear();
        this.valuedSupport.fireEventOccured(Events.CLEARED_GATEWAYS, null);
    }

    public boolean contains(Gateway gateway) {
        Validate.notNull(gateway);
        return gateways.contains(gateway);
    }

    public int size() {
        return gateways.size();
    }

    public boolean isEmpty() {
        return gateways.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<DeprecatedGateway> getDeprecatedGateways() {
        Set<DeprecatedGateway> set = deprecatedGateways;
        synchronized (set) {
            HashSet<DeprecatedGateway> gws = new HashSet<DeprecatedGateway>(deprecatedGateways);
            return gws;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeprecatedGateways(Set<DeprecatedGateway> deprecatedGateways) {
        Set<DeprecatedGateway> set = deprecatedGateways;
        synchronized (set) {
            Gateways.deprecatedGateways.clear();
            if (deprecatedGateways != null) {
                Gateways.deprecatedGateways.addAll(deprecatedGateways);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gateway get(String gatewayName) {
        if (gatewayName == null) {
            return null;
        }
        SortedSet<Gateway> sortedSet = gateways;
        synchronized (sortedSet) {
            for (Gateway gateway : gateways) {
                if (!gateway.getName().equals(gatewayName)) continue;
                return gateway;
            }
        }
        return null;
    }

    public static boolean isFakeGateway(String gatewayName) {
        return StringUtils.contains(gatewayName, "]fake");
    }

    public Tuple<ArrayList<Gateway>, Boolean> suggestGateway(String number) {
        if (number == null || number.length() < 2) {
            return new Tuple<ArrayList<Gateway>, Boolean>(new ArrayList(), false);
        }
        TreeSet<Gateway> selectedGateways = this.getVisible();
        ArrayList<Gateway> result = new ArrayList<Gateway>();
        final HashMap<String, Integer> usage = this.computeGatewayUsage();
        Iterator it = selectedGateways.iterator();
        while (it.hasNext()) {
            Gateway gateway = (Gateway)it.next();
            if (Gateways.isFakeGateway(gateway.getName())) {
                it.remove();
                continue;
            }
            if (Gateways.isNumberSupported(gateway, number)) continue;
            it.remove();
        }
        for (Gateway gateway : selectedGateways) {
            if (!gateway.isFavorite() || !Gateways.isNumberPreferred(gateway, number)) continue;
            result.add(gateway);
        }
        if (!result.isEmpty()) {
            Collections.sort(result, new Comparator<Gateway>(){

                @Override
                public int compare(Gateway o1, Gateway o2) {
                    Integer popularity1 = (Integer)usage.get(o1.getName());
                    Integer popularity2 = (Integer)usage.get(o2.getName());
                    return popularity1.compareTo(popularity2);
                }
            });
            return new Tuple<ArrayList<Gateway>, Boolean>(result, true);
        }
        int max = 1;
        for (Gateway gw : selectedGateways) {
            if (!Gateways.isNumberPreferred(gw, number)) continue;
            int popularity = usage.get(gw.getName());
            if (popularity > max) {
                max = popularity;
                result.clear();
                result.add(gw);
                continue;
            }
            if (popularity != max) continue;
            result.add(gw);
        }
        if (!result.isEmpty()) {
            return new Tuple<ArrayList<Gateway>, Boolean>(result, true);
        }
        HashMap<Gateway, Integer> hashMap = new HashMap<Gateway, Integer>();
        for (Gateway gw : selectedGateways) {
            hashMap.put(gw, 0);
            if (gw.hasFeature(Gateway.Feature.LOGIN_ONLY) && keyring.getKey(gw.getName()) == null) {
                hashMap.put(gw, (Integer)hashMap.get(gw) - 1);
            }
            if (Gateways.isNumberPreferred(gw, number)) continue;
            hashMap.put(gw, (Integer)hashMap.get(gw) - 1);
        }
        max = Integer.MIN_VALUE;
        for (Gateway gw : selectedGateways) {
            int score = (Integer)hashMap.get(gw);
            if (score > max) {
                max = score;
                result.clear();
                result.add(gw);
                continue;
            }
            if (score != max) continue;
            result.add(gw);
        }
        return new Tuple<ArrayList<Gateway>, Boolean>(result, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Integer> computeGatewayUsage() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Contact contact : Contacts.getInstance().getAll()) {
            String string = contact.getGateway();
            if (result.containsKey(string)) {
                result.put(string, (Integer)result.get(string) + 1);
                continue;
            }
            result.put(string, 1);
        }
        SortedSet<Gateway> sortedSet = gateways;
        synchronized (sortedSet) {
            for (Gateway gateway : gateways) {
                if (result.containsKey(gateway.getName())) continue;
                result.put(gateway.getName(), 0);
            }
        }
        return result;
    }

    public static boolean isNumberSupported(Gateway gateway, String number) {
        String[] supportedPrefixes = gateway.getSupportedPrefixes();
        if (supportedPrefixes.length == 0) {
            return true;
        }
        boolean matched = false;
        for (String prefix : supportedPrefixes) {
            if (!number.startsWith(prefix)) continue;
            matched = true;
            break;
        }
        return matched;
    }

    public static boolean isNumberPreferred(Gateway gateway, String number) {
        if (gateway == null || number == null || number.length() < 2) {
            return false;
        }
        String[] preferredPrefixes = gateway.getPreferredPrefixes();
        if (preferredPrefixes.length == 0) {
            return true;
        }
        boolean matched = false;
        for (String prefix : preferredPrefixes) {
            if (!number.startsWith(prefix)) continue;
            matched = true;
            break;
        }
        return matched;
    }

    public static String convertDelayToHumanString(long delay, boolean inMilliseconds) {
        if (inMilliseconds) {
            delay = Math.round((double)delay / 1000.0);
        }
        long seconds = delay % 60L;
        long minutes = delay / 60L % 60L;
        long hours = delay / 3600L;
        StringBuilder builder = new StringBuilder();
        builder.append(seconds);
        builder.append(l10n.getString("QueuePanel.second_shortcut"));
        if (minutes > 0L) {
            builder.insert(0, l10n.getString("QueuePanel.minute_shortcut") + " ");
            builder.insert(0, minutes);
        }
        if (hours > 0L) {
            builder.insert(0, l10n.getString("QueuePanel.hour_shortcut") + " ");
            builder.insert(0, hours);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GatewayInfo parseInfo(URL script) throws IOException, ScriptException, IntrospectionException {
        logger.log(Level.FINER, "Parsing info of script: {0}", script.toExternalForm());
        if (jsEngine == null) {
            throw new IntrospectionException("JavaScript execution not supported");
        }
        Invocable invocable = (Invocable)((Object)jsEngine);
        Reader reader = null;
        try {
            GatewayInfo gatewayInfo;
            reader = new InputStreamReader(script.openStream(), "UTF-8");
            SimpleScriptContext context = new SimpleScriptContext();
            jsEngine.setContext(context);
            jsEngine.eval(reader);
            GatewayInfo gatewayInfo2 = gatewayInfo = invocable.getInterface(GatewayInfo.class);
            return gatewayInfo2;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Error closing script: " + script.toExternalForm(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeSet<Gateway> getFavorites() {
        TreeSet<Gateway> favorites = new TreeSet<Gateway>();
        SortedSet<Gateway> sortedSet = gateways;
        synchronized (sortedSet) {
            for (Gateway gw : gateways) {
                if (!gw.isFavorite()) continue;
                favorites.add(gw);
            }
        }
        return favorites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeSet<Gateway> getHidden() {
        TreeSet<Gateway> hidden = new TreeSet<Gateway>();
        SortedSet<Gateway> sortedSet = gateways;
        synchronized (sortedSet) {
            for (Gateway gw : gateways) {
                if (!gw.isHidden()) continue;
                hidden.add(gw);
            }
        }
        return hidden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeSet<Gateway> getVisible() {
        TreeSet<Gateway> visible = new TreeSet<Gateway>();
        SortedSet<Gateway> sortedSet = gateways;
        synchronized (sortedSet) {
            for (Gateway gw : gateways) {
                if (gw.isHidden()) continue;
                visible.add(gw);
            }
        }
        return visible;
    }

    private void updateFavorites() {
        HashSet<Gateway> oldFavorites = new HashSet<Gateway>(this.getFavorites());
        for (Gateway gw : oldFavorites) {
            gw.setFavorite(false);
        }
        HashSet<String> favorites = new HashSet<String>(Arrays.asList(config.getFavoriteGateways()));
        HashSet<String> nonexistent = new HashSet<String>();
        for (String gw : favorites) {
            Gateway gateway = this.get(gw);
            if (gateway == null) {
                nonexistent.add(gw);
                continue;
            }
            gateway.setFavorite(true);
        }
        TreeSet<Gateway> newFavorites = this.getFavorites();
        if (!nonexistent.isEmpty()) {
            logger.log(Level.FINE, "Found non-existent favorite gateways, removing from favorites: {0}", nonexistent);
            favorites = new HashSet<String>(favorites);
            favorites.removeAll(nonexistent);
            config.setFavoriteGateways(favorites.toArray(new String[0]));
        }
        if (!CollectionUtils.isEqualCollection(oldFavorites, newFavorites)) {
            this.valuedSupport.fireEventOccured(Events.FAVORITES_UPDATED, null);
        }
    }

    private void updateHidden() {
        HashSet<Gateway> oldHidden = new HashSet<Gateway>(this.getHidden());
        for (Gateway gw : oldHidden) {
            gw.setHidden(false);
        }
        HashSet<String> hidden = new HashSet<String>(Arrays.asList(config.getHiddenGateways()));
        HashSet<String> nonexistent = new HashSet<String>();
        for (String gw : hidden) {
            Gateway gateway = this.get(gw);
            if (gateway == null) {
                nonexistent.add(gw);
                continue;
            }
            gateway.setHidden(true);
        }
        TreeSet<Gateway> newHidden = this.getHidden();
        if (!nonexistent.isEmpty()) {
            logger.log(Level.FINE, "Found non-existent hidden gateways, removing from hiddens: {0}", nonexistent);
            hidden = new HashSet<String>(hidden);
            hidden.removeAll(nonexistent);
            config.setHiddenGateways(hidden.toArray(new String[0]));
        }
        if (!CollectionUtils.isEqualCollection(oldHidden, newHidden)) {
            this.valuedSupport.fireEventOccured(Events.HIDDEN_UPDATED, null);
        }
    }

    public static enum Events {
        ADDED_GATEWAY,
        ADDED_GATEWAYS,
        REMOVED_GATEWAY,
        REMOVED_GATEWAYS,
        CLEARED_GATEWAYS,
        FAVORITES_UPDATED,
        HIDDEN_UPDATED;

    }
}

