/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd2;
import org.languagetool.rules.Rule;

public class PunctuationMarkAtParagraphEnd2Test {
    @Test
    public void test() throws IOException {
        JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());
        for (Rule rule : lt.getAllRules()) {
            lt.disableRule(rule.getId());
        }
        PunctuationMarkAtParagraphEnd2 rule = new PunctuationMarkAtParagraphEnd2(TestTools.getEnglishMessages(), TestTools.getDemoLanguage());
        rule.setDefaultOn();
        lt.addRule((Rule)rule);
        Assert.assertThat((Object)lt.check("This is a test.").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is a test").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is a really nice test").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is a really nice test, and it has enough tokens\n").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)lt.check("This is a really nice test, and it has enough tokens\n\n").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)lt.check("\"This is a really nice test, and it has enough tokens.\"\n\n").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("\"This is a really nice test, and it has enough tokens\"\n").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("\"This is a really nice test, and it has enough tokens\"\n\n").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is a test.\n\nRegards,\nJim").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is a test.\n\nRegards,\n\nJim").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is a test.\n\nKind Regards,\nJim").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is a test.\n\nKind Regards,\n\nJim").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is a test.\n\nKind Regards,\n\nJim Tester").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is a test.\n\nKind Regards,\n\nJim van Tester").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is headline-style text").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is headline-style text.").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is headline-style text. If it gets longer, a dot is needed.").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is headline-style text. If it gets longer, a dot is needed").size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)lt.check("This is a test\n\nKind Regards,\n\nJim van Tester").size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)lt.check("This is a really nice test, and it has enough tokens\n\nKind Regards,\n\nJim van Tester").size(), (Matcher)CoreMatchers.is((Object)1));
    }
}

