/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.util;

import com.hankcs.hanlp.corpus.document.sentence.word.CompoundWord;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class CorpusUtil {
    public static final String TAG_PLACE = "\u672a##\u5730";
    public static final String TAG_BIGIN = "\u59cb##\u59cb";
    public static final String TAG_OTHER = "\u672a##\u5b83";
    public static final String TAG_GROUP = "\u672a##\u56e2";
    public static final String TAG_NUMBER = "\u672a##\u6570";
    public static final String TAG_PROPER = "\u672a##\u4e13";
    public static final String TAG_TIME = "\u672a##\u65f6";
    public static final String TAG_CLUSTER = "\u672a##\u4e32";
    public static final String TAG_END = "\u672b##\u672b";
    public static final String TAG_PEOPLE = "\u672a##\u4eba";

    public static IWord compile(IWord word) {
        String label = word.getLabel();
        if ("nr".equals(label)) {
            return new Word(word.getValue(), TAG_PEOPLE);
        }
        if ("m".equals(label) || "mq".equals(label)) {
            return new Word(word.getValue(), TAG_NUMBER);
        }
        if ("t".equals(label)) {
            return new Word(word.getValue(), TAG_TIME);
        }
        if ("ns".equals(label)) {
            return new Word(word.getValue(), TAG_PLACE);
        }
        return word;
    }

    public static List<List<IWord>> convert2CompatibleList(List<List<Word>> simpleSentenceList) {
        LinkedList<List<IWord>> compatibleList = new LinkedList<List<IWord>>();
        for (List<Word> wordList : simpleSentenceList) {
            compatibleList.add(new LinkedList<Word>(wordList));
        }
        return compatibleList;
    }

    public static List<IWord> spilt(List<IWord> wordList) {
        ListIterator<IWord> listIterator = wordList.listIterator();
        while (listIterator.hasNext()) {
            IWord word = listIterator.next();
            if (!(word instanceof CompoundWord)) continue;
            listIterator.remove();
            for (Word inner : ((CompoundWord)word).innerList) {
                listIterator.add(inner);
            }
        }
        return wordList;
    }
}

