/*
 * Decompiled with CFR 0.152.
 */
package org.jf.smali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.smali.Smali;
import org.jf.smali.SmaliOptions;
import org.jf.util.jcommander.Command;
import org.jf.util.jcommander.ExtendedParameter;
import org.jf.util.jcommander.ExtendedParameters;

@Parameters(commandDescription="Lexes the given smali file(s) and prints the tokens.", hidden=true)
@ExtendedParameters(commandName="tokens")
public class PrintTokensCommand
extends Command {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information for this command.")
    private boolean help;
    @Parameter(names={"-a", "--api"}, description="The numeric api level to use while assembling.")
    @ExtendedParameter(argumentNames={"api"})
    private int apiLevel = 15;
    @Parameter(description="Assembles the given files. If a directory is specified, it will be recursively searched for any files with a .smali prefix")
    @ExtendedParameter(argumentNames={"[<file>|<dir>]+"})
    private List<String> input;

    public PrintTokensCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    @Override
    public void run() {
        if (this.help || this.input == null || this.input.isEmpty()) {
            this.usage();
            return;
        }
        try {
            Smali.printTokens(this.getOptions(), this.input);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected SmaliOptions getOptions() {
        SmaliOptions options = new SmaliOptions();
        options.apiLevel = this.apiLevel;
        return options;
    }
}

