/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.broker.ResourceDataBroker;

public class ShortDescriptionProvider {
    private static final Map<Key, String> wordToDef = new HashMap<Key, String>();
    private static final Set<Language> initializedLangs = new HashSet<Language>();
    private static final List<String> filenames = Arrays.asList("word_definitions.txt");

    @Nullable
    public String getShortDescription(String word, Language lang) {
        if (!initializedLangs.contains(lang)) {
            this.init(lang);
        }
        return wordToDef.get(new Key(word, lang));
    }

    public Map<String, String> getAllDescriptions(Language lang) {
        if (!initializedLangs.contains(lang)) {
            this.init(lang);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Key, String> entry : wordToDef.entrySet()) {
            if (!entry.getKey().lang.equals(lang)) continue;
            result.put(entry.getKey().word, entry.getValue());
        }
        return result;
    }

    private void init(Language lang) {
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        for (String filename : filenames) {
            String path = "/" + lang.getShortCode() + "/" + filename;
            if (!dataBroker.resourceExists(path)) continue;
            List<String> lines = dataBroker.getFromResourceDirAsLines(path);
            for (String line : lines) {
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                String[] parts = line.split("\t");
                if (parts.length != 2) {
                    throw new RuntimeException("Format in " + path + " not expected, expected 2 tab-separated columns: '" + line + "'");
                }
                wordToDef.put(new Key(parts[0], lang), parts[1]);
            }
        }
        initializedLangs.add(lang);
    }

    private static class Key {
        String word;
        Language lang;

        Key(String word, Language lang) {
            this.word = Objects.requireNonNull(word);
            this.lang = Objects.requireNonNull(lang);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.word.equals(key.word) && this.lang.equals(key.lang);
        }

        public int hashCode() {
            return Objects.hash(this.word, this.lang);
        }

        public String toString() {
            return this.word + "@" + this.lang.getShortCodeWithCountryAndVariant();
        }
    }
}

