/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.SelectResult;
import groovyx.gpars.dataflow.SelectableChannel;
import groovyx.gpars.dataflow.impl.GuardedSelectRequest;
import groovyx.gpars.dataflow.impl.SelectBase;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Timer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Select<T> {
    private final SelectBase<T> selectBase;
    public static final String TIMEOUT = "timeout";

    public Select(PGroup pGroup, SelectableChannel<? extends T> ... channels) {
        this.selectBase = new SelectBase<T>(pGroup, Arrays.asList(channels));
    }

    public Select(PGroup pGroup, List<SelectableChannel<? extends T>> channels) {
        this.selectBase = new SelectBase<T>(pGroup, channels);
    }

    public SelectResult<T> select() throws InterruptedException {
        return this.select(-1, null);
    }

    public SelectResult<T> select(List<Boolean> mask) throws InterruptedException {
        return this.select(-1, mask);
    }

    public static DataflowReadChannel<String> createTimeout(long timeout) {
        final DataflowVariable<String> result = new DataflowVariable<String>();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                result.bind(Select.TIMEOUT);
            }
        };
        Timer.timer.schedule(task, timeout, TimeUnit.MILLISECONDS);
        return result;
    }

    public void select(MessageStream messageStream) throws InterruptedException {
        this.select(messageStream, -1, null);
    }

    public void select(MessageStream messageStream, List<Boolean> mask) throws InterruptedException {
        this.select(messageStream, -1, mask);
    }

    public Promise<SelectResult<T>> selectToPromise() throws InterruptedException {
        return this.selectToPromise(-1, null);
    }

    public Promise<SelectResult<T>> selectToPromise(List<Boolean> mask) throws InterruptedException {
        return this.selectToPromise(-1, mask);
    }

    public SelectResult<T> prioritySelect() throws InterruptedException {
        return this.select(0, null);
    }

    public SelectResult<T> prioritySelect(List<Boolean> mask) throws InterruptedException {
        return this.select(0, mask);
    }

    public void prioritySelect(MessageStream messageStream) throws InterruptedException {
        this.select(messageStream, 0, null);
    }

    public void prioritySelect(MessageStream messageStream, List<Boolean> mask) throws InterruptedException {
        this.select(messageStream, 0, mask);
    }

    public Promise<SelectResult<T>> prioritySelectToPromise() throws InterruptedException {
        return this.selectToPromise(0, null);
    }

    public Promise<SelectResult<T>> prioritySelectToPromise(List<Boolean> mask) throws InterruptedException {
        return this.selectToPromise(0, mask);
    }

    public final SelectResult<T> call() throws InterruptedException {
        return this.select();
    }

    public final SelectResult<T> call(List<Boolean> mask) throws InterruptedException {
        return this.select(mask);
    }

    public final void call(MessageStream messageStream) throws InterruptedException {
        this.select(messageStream);
    }

    public final void call(MessageStream messageStream, List<Boolean> mask) throws InterruptedException {
        this.select(messageStream, mask);
    }

    private Promise<SelectResult<T>> selectToPromise(int startIndex, List<Boolean> mask) throws InterruptedException {
        final DataflowVariable<SelectResult<T>> result = new DataflowVariable<SelectResult<T>>();
        this.selectBase.doSelect(startIndex, new GuardedSelectRequest<T>(mask){

            @Override
            public void valueFound(int index, T value) {
                result.bind(new SelectResult(index, value));
            }
        });
        return result;
    }

    private void select(final MessageStream messageStream, int startIndex, List<Boolean> mask) throws InterruptedException {
        this.selectBase.doSelect(startIndex, new GuardedSelectRequest<T>(mask){

            @Override
            public void valueFound(int index, T value) {
                messageStream.send(new SelectResult(index, value));
            }
        });
    }

    private SelectResult<T> select(int startIndex, List<Boolean> mask) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final int[] foundIndex = new int[1];
        final Object[] foundValue = new Object[1];
        this.selectBase.doSelect(startIndex, new GuardedSelectRequest<T>(mask){

            @Override
            public void valueFound(int index, T value) {
                foundIndex[0] = index;
                foundValue[0] = value;
                latch.countDown();
            }
        });
        latch.await();
        return new SelectResult<Object>(foundIndex[0], foundValue[0]);
    }
}

