/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class IOUtils {
    public static boolean deleteRecursive(File file) throws FileNotFoundException {
        File[] fileArray;
        boolean bl = true;
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                bl = bl && IOUtils.deleteRecursive(file2);
            }
        }
        return bl && file.delete();
    }

    public static void copyFromURL(URL uRL, File file) throws IOException {
        int n;
        if (uRL == null) {
            throw new IOException("Missing input resource!");
        }
        if (file.exists()) {
            file.delete();
        }
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
        inputStream.close();
        file.setReadOnly();
        file.setReadable(true, false);
    }

    public static void copyFile(File file, File file2) throws IOException {
        file2.getParentFile().mkdirs();
        file2.delete();
        file2.createNewFile();
        FileChannel fileChannel = null;
        FileChannel fileChannel2 = null;
        fileChannel = new FileInputStream(file).getChannel();
        fileChannel2 = new FileOutputStream(file2).getChannel();
        if (fileChannel2 != null && fileChannel != null) {
            fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
        }
        if (fileChannel != null) {
            fileChannel.close();
        }
        if (fileChannel2 != null) {
            fileChannel2.close();
        }
        if (file.canExecute()) {
            file2.setExecutable(true, false);
        }
        if (!file.canWrite()) {
            file2.setReadOnly();
        }
        file2.setReadable(true, false);
    }

    public static long getFolderSize(File file) {
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    l += IOUtils.getFolderSize(file2);
                    continue;
                }
                l += file2.length();
            }
        }
        return l;
    }

    public static void run(String string, File file, boolean bl) throws IOException {
        if (file != null && file.exists()) {
            ProcessBuilder processBuilder = new ProcessBuilder(string, file.getName());
            processBuilder = processBuilder.directory(file.getParentFile());
            IOUtils.exec(processBuilder, bl);
        }
    }

    public static void exec(ProcessBuilder processBuilder, boolean bl) throws IOException {
        IOUtils.exec(processBuilder, bl, false);
    }

    public static void exec(ProcessBuilder processBuilder, boolean bl, boolean bl2) throws IOException {
        IOUtils.exec(processBuilder, bl, bl2, null);
    }

    public static void exec(ProcessBuilder processBuilder, boolean bl, boolean bl2, PrintStream printStream) throws IOException {
        String string;
        processBuilder.redirectErrorStream(true);
        Log.verbose("Running " + Arrays.toString(processBuilder.command().toArray(new String[0])) + (processBuilder.directory() != null ? " in " + processBuilder.directory() : ""));
        Process process = processBuilder.start();
        InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((string = bufferedReader.readLine()) != null) {
            if (printStream != null) {
                printStream.print(string);
                continue;
            }
            if (bl) {
                Log.info(string);
                continue;
            }
            Log.debug(string);
        }
        try {
            int n = process.waitFor();
            if (!(n == 0 || bl2 && n != 127)) {
                throw new IOException("Exec failed with code " + n + " command [" + Arrays.toString(processBuilder.command().toArray(new String[0])) + " in " + (processBuilder.directory() != null ? processBuilder.directory().getAbsolutePath() : "unspecified directory"));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean isNotSymbolicLink(File file) {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return true;
        }
        try {
            if (file == null || file.getParent() == null) {
                return false;
            }
            File file2 = new File(file.getParentFile().getCanonicalFile(), file.getName());
            if (file2.getCanonicalFile().equals(file2.getAbsoluteFile())) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static byte[] readFully(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

