/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.sun.javafx.tools.ant.Utils;
import com.sun.javafx.tools.packager.PackagerLib;
import com.sun.javafx.tools.packager.SignJarParams;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class FXSignJarTask
extends Task {
    private File keyStore;
    private String alias;
    private String storePass;
    private String keyPass;
    private String storeType = "jks";
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private String deprecatedSourceJar;
    private String sourceJar;
    private String destDir;
    private PackagerLib packager = new PackagerLib();
    private SignJarParams signJarParams = new SignJarParams();
    private boolean verbose = false;

    public void execute() throws BuildException {
        this.signJarParams.setKeyStore(this.keyStore);
        this.signJarParams.setAlias(this.alias);
        this.signJarParams.setStorePass(this.storePass);
        this.signJarParams.setKeyPass(this.keyPass);
        this.signJarParams.setStoreType(this.storeType);
        this.signJarParams.setVerbose(this.verbose);
        if (this.destDir != null) {
            this.signJarParams.setOutdir(new File(this.destDir));
        }
        if (!this.fileSets.isEmpty()) {
            if (this.deprecatedSourceJar != null) {
                throw new IllegalArgumentException("Unexpected sourcejar attribute when fileset present");
            }
            if (this.sourceJar != null) {
                throw new IllegalArgumentException("Unexpected sourcejar attribute when fileset present");
            }
        }
        if (this.sourceJar != null && this.deprecatedSourceJar != null) {
            throw new IllegalArgumentException("Cannot use both sourcejar and jar attributes. (sourcejar attribute is deprecated).");
        }
        Object object = this.fileSets.iterator();
        while (object.hasNext()) {
            FileSet fileSet = object.next();
            Utils.addResources(this.signJarParams, fileSet);
        }
        if (this.deprecatedSourceJar != null && ((File)(object = new File(this.deprecatedSourceJar))).exists()) {
            this.signJarParams.addResource(new File("."), (File)object);
        }
        if (this.sourceJar != null && ((File)(object = new File(this.sourceJar))).exists()) {
            this.signJarParams.addResource(((File)object).getParentFile(), ((File)object).getName());
        }
        try {
            this.signJarParams.validate();
            this.packager.signJar(this.signJarParams);
        }
        catch (Exception exception) {
            throw new BuildException(exception.getMessage(), (Throwable)exception);
        }
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setVerbose(Boolean bl) {
        this.verbose = bl;
    }

    public void setKeyPass(String string) {
        this.keyPass = string;
    }

    public void setStorePass(String string) {
        this.storePass = string;
    }

    public void setKeyStore(File file) {
        this.keyStore = file;
    }

    public void setStoreType(String string) {
        this.storeType = string;
    }

    public void addFileSet(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setSourceJar(String string) {
        this.deprecatedSourceJar = string;
    }

    public void setJar(String string) {
        this.sourceJar = string;
    }

    public void setDestDir(String string) {
        this.destDir = string;
    }
}

