/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.parameters;

import java.io.IOException;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class DoubleParameter
implements Cloneable,
ParameterHolder {
    private final double value;

    public DoubleParameter(double value) {
        this.value = value;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(String.valueOf(this.value).getBytes());
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return String.valueOf(this.value).getBytes().length;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        pos.writeLong(Double.doubleToLongBits(this.value));
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.DOUBLE;
    }

    @Override
    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

