/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.AndroidInputDevice;
import com.sun.glass.ui.monocle.AndroidInputProcessor;
import com.sun.glass.ui.monocle.InputDeviceRegistry;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.LinuxKeyProcessor;
import com.sun.glass.ui.monocle.TouchState;
import java.security.AllPermission;
import javafx.application.Platform;

public class AndroidInputDeviceRegistry
extends InputDeviceRegistry {
    private static AndroidInputDeviceRegistry instance = new AndroidInputDeviceRegistry();
    private AndroidInputDevice androidDevice;
    private AndroidInputProcessor processor;
    private final KeyState keyState = new KeyState();

    static AndroidInputDeviceRegistry getInstance() {
        return instance;
    }

    public static void registerDevice() {
        Platform.runLater(() -> instance.createDevice());
    }

    public static void gotTouchEventFromNative(int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n2) {
        TouchState touchState = new TouchState();
        if (n2 == -1) {
            System.out.println("don't add points, primary = -1");
        } else {
            for (int i = 0; i < n; ++i) {
                TouchState.Point point = new TouchState.Point();
                point.id = nArray2[i];
                point.x = nArray3[i];
                point.y = nArray4[i];
                touchState.addPoint(point);
            }
        }
        instance.gotTouchEvent(touchState);
    }

    private void gotTouchEvent(TouchState touchState) {
        if (this.androidDevice == null) {
            System.out.println("[MON] got touch event, but no registered device yet");
            Thread.dumpStack();
            return;
        }
        if (this.processor == null) {
            System.out.println("[MON] got touch event, but processor not yet initialized");
            Thread.dumpStack();
            return;
        }
        this.processor.pushEvent(touchState);
    }

    public static void gotKeyEventFromNative(int n, int n2) {
        instance.gotKeyEvent(n, n2);
    }

    private void gotKeyEvent(int n, int n2) {
        int n3 = LinuxKeyProcessor.getVirtualKeyCode(n2);
        if (n == 0) {
            this.keyState.pressKey(n3);
        } else if (n == 1) {
            this.keyState.releaseKey(n3);
        } else {
            System.out.println("[JVDBG] ERROR, what action is this? " + n);
        }
        instance.gotKeyEvent(this.keyState);
    }

    private void gotKeyEvent(KeyState keyState) {
        this.processor.pushKeyEvent(keyState);
    }

    private AndroidInputDeviceRegistry() {
    }

    private void createDevice() {
        System.out.println("[MON] Create device");
        AndroidInputDevice androidInputDevice = new AndroidInputDevice();
        this.androidDevice = this.addDeviceInternal(androidInputDevice, "Android Touch Input");
        System.out.println("[MON] Create device done, add done");
    }

    private AndroidInputDevice addDeviceInternal(AndroidInputDevice androidInputDevice, String string) {
        this.processor = this.createInputProcessor(androidInputDevice);
        androidInputDevice.setInputProcessor(this.processor);
        Thread thread = new Thread(androidInputDevice);
        thread.setName(string);
        thread.setDaemon(true);
        thread.start();
        this.devices.add(androidInputDevice);
        return androidInputDevice;
    }

    void removeDevice(AndroidInputDevice androidInputDevice) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        this.devices.remove(androidInputDevice);
    }

    private AndroidInputProcessor createInputProcessor(AndroidInputDevice androidInputDevice) {
        return new AndroidInputProcessor(androidInputDevice);
    }
}

