/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.languagetool.Language;
import org.languagetool.ShortDescriptionProvider;
import org.languagetool.rules.ConfusionPair;
import org.languagetool.rules.ConfusionString;

public class ConfusionSetLoader {
    private static final String CHARSET = "utf-8";
    private final ShortDescriptionProvider wordDefs = new ShortDescriptionProvider();
    private final Language lang;

    public ConfusionSetLoader(Language lang) {
        this.lang = Objects.requireNonNull(lang);
    }

    public Map<String, List<ConfusionPair>> loadConfusionPairs(InputStream stream) throws IOException {
        HashMap<String, List<ConfusionPair>> map = new HashMap<String, List<ConfusionPair>>();
        try (InputStreamReader reader = new InputStreamReader(stream, CHARSET);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            block18: while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                String[] parts = line.replaceFirst("\\s*#.*", "").split("\\s*(;|->)\\s*");
                if (parts.length != 3) {
                    throw new RuntimeException("Unexpected format: '" + line + "' - expected three semicolon-separated values: word1; word2; factor");
                }
                boolean bidirectional = !line.replaceFirst("#.*", "").contains(" -> ");
                ArrayList<ConfusionString> confusionStrings = new ArrayList<ConfusionString>();
                HashSet<String> loadedForSet = new HashSet<String>();
                String prevWord = null;
                for (String part : Arrays.asList(parts).subList(0, parts.length - 1)) {
                    String description;
                    String[] subParts = part.split("\\|");
                    String word = subParts[0];
                    if (bidirectional && prevWord != null && word.compareTo(prevWord) < 0) {
                        throw new RuntimeException("Order words alphabetically per line in the confusion set file: " + line + ": found " + word + " after " + prevWord);
                    }
                    prevWord = word;
                    String string = description = subParts.length == 2 ? subParts[1] : null;
                    if (loadedForSet.contains(word)) {
                        throw new RuntimeException("Word appears twice in same confusion set: '" + word + "'");
                    }
                    if (description == null) {
                        description = this.wordDefs.getShortDescription(word, this.lang);
                    }
                    confusionStrings.add(new ConfusionString(word, description));
                    loadedForSet.add(word);
                }
                ConfusionPair confusionSet = new ConfusionPair((ConfusionString)confusionStrings.get(0), (ConfusionString)confusionStrings.get(1), Long.parseLong(parts[parts.length - 1]), bidirectional);
                for (ConfusionString confusionString : confusionStrings) {
                    String key = confusionString.getString();
                    List existingEntry = (List)map.get(key);
                    if (existingEntry != null) {
                        existingEntry.add(confusionSet);
                    } else {
                        ArrayList<ConfusionPair> pairs = new ArrayList<ConfusionPair>();
                        pairs.add(confusionSet);
                        map.put(key, pairs);
                    }
                    if (bidirectional) continue;
                    continue block18;
                }
            }
        }
        return map;
    }
}

