/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.clsdescriptioneditor;

import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class ExpressionEditorPreferences {
    public static final String PREFERENCES_KEY = "org.protege.editor.owl.expressioneditor";
    public static final String USE_EXPRESSION_COMPLETION_KEY = "USE_REGULAR_EXPRESSIONS";
    public static final String CHECK_DELAY_KEY = "CHECK_DELAY_KEY";
    private static ExpressionEditorPreferences instance;
    private boolean useExpressionCompletion;
    private int checkDelay;

    private ExpressionEditorPreferences() {
        this.load();
    }

    private static Preferences getPreferences() {
        return PreferencesManager.getInstance().getApplicationPreferences(PREFERENCES_KEY);
    }

    private void load() {
        Preferences prefs = ExpressionEditorPreferences.getPreferences();
        this.useExpressionCompletion = prefs.getBoolean(USE_EXPRESSION_COMPLETION_KEY, true);
        this.checkDelay = prefs.getInt(CHECK_DELAY_KEY, 120);
    }

    public boolean isUseExpressionCompletion() {
        return this.useExpressionCompletion;
    }

    public void setUseExpressionCompletion(boolean useExpressionCompletion) {
        this.useExpressionCompletion = useExpressionCompletion;
        ExpressionEditorPreferences.getPreferences().putBoolean(USE_EXPRESSION_COMPLETION_KEY, useExpressionCompletion);
    }

    public int getCheckDelay() {
        return this.checkDelay;
    }

    public void setCheckDelay(int checkDelay) {
        this.checkDelay = checkDelay;
        ExpressionEditorPreferences.getPreferences().putInt(CHECK_DELAY_KEY, checkDelay);
    }

    public static synchronized ExpressionEditorPreferences getInstance() {
        if (instance == null) {
            instance = new ExpressionEditorPreferences();
        }
        return instance;
    }
}

