/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.authentication;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import org.mariadb.jdbc.authentication.AuthenticationPlugin;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.read.ErrorPacket;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.util.Options;

public class Sha256PasswordPlugin
implements AuthenticationPlugin {
    private String authenticationData;
    private Options options;
    private byte[] seed;

    public static PublicKey readPublicKeyFromFile(String serverRsaPublicKeyFile) throws SQLException {
        byte[] keyBytes;
        try {
            keyBytes = Files.readAllBytes(Paths.get(serverRsaPublicKeyFile, new String[0]));
        }
        catch (IOException ex) {
            throw new SQLException("Could not read server RSA public key from file : serverRsaPublicKeyFile=" + serverRsaPublicKeyFile, "S1009", ex);
        }
        return Sha256PasswordPlugin.generatePublicKey(keyBytes);
    }

    public static PublicKey readPublicKeyFromSocket(PacketInputStream reader, AtomicInteger sequence) throws SQLException, IOException {
        Buffer buffer = reader.getPacket(true);
        sequence.set(reader.getLastPacketSeq());
        switch (buffer.getByteAt(0)) {
            case -1: {
                ErrorPacket ep = new ErrorPacket(buffer);
                String message = ep.getMessage();
                throw new SQLException("Could not connect: " + message, ep.getSqlState(), ep.getErrorNumber());
            }
            case -2: {
                throw new SQLException("Could not connect: receive AuthSwitchRequest in place of RSA public key. Did user has the rights to connect to database ?");
            }
        }
        buffer.skipByte();
        return Sha256PasswordPlugin.generatePublicKey(buffer.readRawBytes(buffer.remaining()));
    }

    public static PublicKey generatePublicKey(byte[] publicKeyBytes) throws SQLException {
        try {
            String publicKey = new String(publicKeyBytes).replaceAll("(-+BEGIN PUBLIC KEY-+\\r?\\n|\\n?-+END PUBLIC KEY-+\\r?\\n?)", "");
            byte[] keyBytes = Base64.getMimeDecoder().decode(publicKey);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(spec);
        }
        catch (Exception ex) {
            throw new SQLException("Could read server RSA public key: " + ex.getMessage(), "S1009", ex);
        }
    }

    public static byte[] encrypt(PublicKey publicKey, String password, byte[] seed, String passwordCharacterEncoding) throws SQLException, UnsupportedEncodingException {
        byte[] correctedSeed = seed.length > 0 ? Arrays.copyOfRange(seed, 0, seed.length - 1) : new byte[]{};
        byte[] bytePwd = passwordCharacterEncoding != null && !passwordCharacterEncoding.isEmpty() ? password.getBytes(passwordCharacterEncoding) : password.getBytes();
        byte[] nullFinishedPwd = Arrays.copyOf(bytePwd, bytePwd.length + 1);
        byte[] xorBytes = new byte[nullFinishedPwd.length];
        int seedLength = correctedSeed.length;
        for (int i = 0; i < xorBytes.length; ++i) {
            xorBytes[i] = (byte)(nullFinishedPwd[i] ^ correctedSeed[i % seedLength]);
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, publicKey);
            return cipher.doFinal(xorBytes);
        }
        catch (Exception ex) {
            throw new SQLException("Could not connect using SHA256 plugin : " + ex.getMessage(), "S1009", ex);
        }
    }

    @Override
    public String name() {
        return "Sha256 authentication plugin";
    }

    @Override
    public String type() {
        return "sha256_password";
    }

    @Override
    public void initialize(String authenticationData, byte[] seed, Options options) {
        this.seed = seed;
        this.authenticationData = authenticationData;
        this.options = options;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException, SQLException {
        if (this.authenticationData == null || this.authenticationData.isEmpty()) {
            out.writeEmptyPacket(sequence.incrementAndGet());
        } else if (Boolean.TRUE.equals(this.options.useSsl)) {
            out.startPacket(sequence.incrementAndGet());
            byte[] bytePwd = this.options.passwordCharacterEncoding != null && !this.options.passwordCharacterEncoding.isEmpty() ? this.authenticationData.getBytes(this.options.passwordCharacterEncoding) : this.authenticationData.getBytes();
            out.write(bytePwd);
            out.write(0);
            out.flush();
        } else {
            PublicKey publicKey;
            if (this.options.serverRsaPublicKeyFile != null && !this.options.serverRsaPublicKeyFile.isEmpty()) {
                publicKey = Sha256PasswordPlugin.readPublicKeyFromFile(this.options.serverRsaPublicKeyFile);
            } else {
                if (!this.options.allowPublicKeyRetrieval) {
                    throw new SQLException("RSA public key is not available client side (option serverRsaPublicKeyFile)", "S1009");
                }
                out.startPacket(sequence.incrementAndGet());
                out.write(1);
                out.flush();
                publicKey = Sha256PasswordPlugin.readPublicKeyFromSocket(in, sequence);
            }
            try {
                byte[] cipherBytes = Sha256PasswordPlugin.encrypt(publicKey, this.authenticationData, this.seed, this.options.passwordCharacterEncoding);
                out.startPacket(sequence.incrementAndGet());
                out.write(cipherBytes);
                out.flush();
            }
            catch (Exception ex) {
                throw new SQLException("Could not connect using SHA256 plugin : " + ex.getMessage(), "S1009", ex);
            }
        }
        Buffer buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        return buffer;
    }
}

