/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.StringIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeIdItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class DebugInfoItem {
    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                return "debug_info_item";
            }

            @Override
            public void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                DexReader reader = this.dexFile.getBuffer().readerAt(out.getCursor());
                int lineStart = reader.readBigUleb128();
                out.annotateTo(reader.getOffset(), "line_start = %d", (long)lineStart & 0xFFFFFFFFL);
                int parametersSize = reader.readSmallUleb128();
                out.annotateTo(reader.getOffset(), "parameters_size = %d", parametersSize);
                if (parametersSize > 0) {
                    out.annotate(0, "parameters:", new Object[0]);
                    out.indent();
                    for (int i = 0; i < parametersSize; ++i) {
                        int paramaterIndex = reader.readSmallUleb128() - 1;
                        out.annotateTo(reader.getOffset(), "%s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, paramaterIndex, true));
                    }
                    out.deindent();
                }
                out.annotate(0, "debug opcodes:", new Object[0]);
                out.indent();
                int codeAddress = 0;
                int lineNumber = lineStart;
                block13: while (true) {
                    int opcode = reader.readUbyte();
                    switch (opcode) {
                        case 0: {
                            out.annotateTo(reader.getOffset(), "DBG_END_SEQUENCE", new Object[0]);
                            break block13;
                        }
                        case 1: {
                            out.annotateTo(reader.getOffset(), "DBG_ADVANCE_PC", new Object[0]);
                            out.indent();
                            int addressDiff = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "addr_diff = +0x%x: 0x%x", addressDiff, codeAddress += addressDiff);
                            out.deindent();
                            continue block13;
                        }
                        case 2: {
                            out.annotateTo(reader.getOffset(), "DBG_ADVANCE_LINE", new Object[0]);
                            out.indent();
                            int lineDiff = reader.readSleb128();
                            out.annotateTo(reader.getOffset(), "line_diff = +%d: %d", Math.abs(lineDiff), lineNumber += lineDiff);
                            out.deindent();
                            continue block13;
                        }
                        case 3: {
                            out.annotateTo(reader.getOffset(), "DBG_START_LOCAL", new Object[0]);
                            out.indent();
                            int registerNum = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "register_num = v%d", registerNum);
                            int nameIndex = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "name_idx = %s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, nameIndex, true));
                            int typeIndex = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "type_idx = %s", TypeIdItem.getOptionalReferenceAnnotation(this.dexFile, typeIndex));
                            out.deindent();
                            continue block13;
                        }
                        case 4: {
                            out.annotateTo(reader.getOffset(), "DBG_START_LOCAL_EXTENDED", new Object[0]);
                            out.indent();
                            int registerNum = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "register_num = v%d", registerNum);
                            int nameIndex = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "name_idx = %s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, nameIndex, true));
                            int typeIndex = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "type_idx = %s", TypeIdItem.getOptionalReferenceAnnotation(this.dexFile, typeIndex));
                            int sigIndex = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "sig_idx = %s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, sigIndex, true));
                            out.deindent();
                            continue block13;
                        }
                        case 5: {
                            out.annotateTo(reader.getOffset(), "DBG_END_LOCAL", new Object[0]);
                            out.indent();
                            int registerNum = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "register_num = v%d", registerNum);
                            out.deindent();
                            continue block13;
                        }
                        case 6: {
                            out.annotateTo(reader.getOffset(), "DBG_RESTART_LOCAL", new Object[0]);
                            out.indent();
                            int registerNum = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "register_num = v%d", registerNum);
                            out.deindent();
                            continue block13;
                        }
                        case 7: {
                            out.annotateTo(reader.getOffset(), "DBG_SET_PROLOGUE_END", new Object[0]);
                            continue block13;
                        }
                        case 8: {
                            out.annotateTo(reader.getOffset(), "DBG_SET_EPILOGUE_BEGIN", new Object[0]);
                            continue block13;
                        }
                        case 9: {
                            out.annotateTo(reader.getOffset(), "DBG_SET_FILE", new Object[0]);
                            out.indent();
                            int nameIdx = reader.readSmallUleb128() - 1;
                            out.annotateTo(reader.getOffset(), "name_idx = %s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, nameIdx));
                            out.deindent();
                            continue block13;
                        }
                        default: {
                            int adjusted = opcode - 10;
                            int addressDiff = adjusted / 15;
                            int lineDiff = adjusted % 15 - 4;
                            out.annotateTo(reader.getOffset(), "address_diff = +0x%x:0x%x, line_diff = +%d:%d, ", addressDiff, codeAddress += addressDiff, lineDiff, lineNumber += lineDiff);
                            continue block13;
                        }
                    }
                    break;
                }
                out.deindent();
            }
        };
    }
}

