/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.scripts;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.bidi.BidiClass;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.scripts.DefaultScriptProcessor;
import org.apache.fop.complexscripts.util.CharAssociation;
import org.apache.fop.complexscripts.util.GlyphContextTester;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public class ArabicScriptProcessor
extends DefaultScriptProcessor {
    private static final Log log = LogFactory.getLog(ArabicScriptProcessor.class);
    private static final String[] GSUB_FEATURES = new String[]{"calt", "ccmp", "fina", "init", "isol", "liga", "medi", "rlig"};
    private static final String[] GPOS_FEATURES = new String[]{"curs", "kern", "mark", "mkmk"};
    private final ScriptContextTester subContextTester = new SubstitutionScriptContextTester();
    private final ScriptContextTester posContextTester = new PositioningScriptContextTester();
    private static final int[] ISOLATED_INITIALS = new int[]{1569, 1570, 1571, 1572, 1573, 1575, 1583, 1584, 1585, 1586, 1608, 1649, 1650, 1651, 1653, 1654, 1655, 1672, 1673, 1674, 1675, 1676, 1677, 1678, 1679, 1680, 1681, 1682, 1683, 1684, 1685, 1686, 1687, 1688, 1689, 1732, 1733, 1734, 1735, 1736, 1737, 1738, 1739, 1743, 1774, 1775};
    private static final int[] ISOLATED_FINALS = new int[]{1569};

    ArabicScriptProcessor(String script) {
        super(script);
    }

    @Override
    public String[] getSubstitutionFeatures() {
        return GSUB_FEATURES;
    }

    @Override
    public ScriptContextTester getSubstitutionContextTester() {
        return this.subContextTester;
    }

    @Override
    public String[] getPositioningFeatures() {
        return GPOS_FEATURES;
    }

    @Override
    public ScriptContextTester getPositioningContextTester() {
        return this.posContextTester;
    }

    @Override
    public GlyphSequence reorderCombiningMarks(GlyphDefinitionTable gdef, GlyphSequence gs, int[] widths, int[][] gpa, String script, String language) {
        return gs;
    }

    private static boolean inFinalContext(String script, String language, String feature, GlyphSequence gs, int index, int flags) {
        int e;
        CharAssociation a = gs.getAssociation(index);
        int[] ca = gs.getCharacterArray(false);
        int nc = gs.getCharacterCount();
        if (nc == 0) {
            return false;
        }
        int s = a.getStart();
        if (!ArabicScriptProcessor.hasFinalPrecedingContext(ca, nc, s, e = a.getEnd())) {
            return false;
        }
        if (!ArabicScriptProcessor.hasFinalThisContext(ca, nc, s, e)) {
            return false;
        }
        if (ArabicScriptProcessor.forceFinalThisContext(ca, nc, s, e)) {
            return true;
        }
        return ArabicScriptProcessor.hasFinalSucceedingContext(ca, nc, s, e);
    }

    private static boolean inInitialContext(String script, String language, String feature, GlyphSequence gs, int index, int flags) {
        int e;
        CharAssociation a = gs.getAssociation(index);
        int[] ca = gs.getCharacterArray(false);
        int nc = gs.getCharacterCount();
        if (nc == 0) {
            return false;
        }
        int s = a.getStart();
        if (!ArabicScriptProcessor.hasInitialPrecedingContext(ca, nc, s, e = a.getEnd())) {
            return false;
        }
        if (!ArabicScriptProcessor.hasInitialThisContext(ca, nc, s, e)) {
            return false;
        }
        return ArabicScriptProcessor.hasInitialSucceedingContext(ca, nc, s, e);
    }

    private static boolean inIsolateContext(String script, String language, String feature, GlyphSequence gs, int index, int flags) {
        CharAssociation a = gs.getAssociation(index);
        int nc = gs.getCharacterCount();
        if (nc == 0) {
            return false;
        }
        return a.getStart() == 0 && a.getEnd() == nc;
    }

    private static boolean inLigatureContext(String script, String language, String feature, GlyphSequence gs, int index, int flags) {
        int e;
        CharAssociation a = gs.getAssociation(index);
        int[] ca = gs.getCharacterArray(false);
        int nc = gs.getCharacterCount();
        if (nc == 0) {
            return false;
        }
        int s = a.getStart();
        if (!ArabicScriptProcessor.hasLigaturePrecedingContext(ca, nc, s, e = a.getEnd())) {
            return false;
        }
        return ArabicScriptProcessor.hasLigatureSucceedingContext(ca, nc, s, e);
    }

    private static boolean inMedialContext(String script, String language, String feature, GlyphSequence gs, int index, int flags) {
        int e;
        CharAssociation a = gs.getAssociation(index);
        int[] ca = gs.getCharacterArray(false);
        int nc = gs.getCharacterCount();
        if (nc == 0) {
            return false;
        }
        int s = a.getStart();
        if (!ArabicScriptProcessor.hasMedialPrecedingContext(ca, nc, s, e = a.getEnd())) {
            return false;
        }
        if (!ArabicScriptProcessor.hasMedialThisContext(ca, nc, s, e)) {
            return false;
        }
        return ArabicScriptProcessor.hasMedialSucceedingContext(ca, nc, s, e);
    }

    private static boolean hasFinalPrecedingContext(int[] ca, int nc, int s, int e) {
        int k;
        int chp = 0;
        int clp = 0;
        for (int i = s; i > 0 && ((k = i - 1) < 0 || k >= nc || (clp = BidiClass.getBidiClass(chp = ca[k])) == 14); --i) {
        }
        if (clp != 5) {
            return ArabicScriptProcessor.isZWJ(chp);
        }
        return !ArabicScriptProcessor.hasIsolateInitial(chp);
    }

    private static boolean hasFinalThisContext(int[] ca, int nc, int s, int e) {
        int k;
        int j;
        int chl = 0;
        int cll = 0;
        int n = e - s;
        for (int i = 0; i < n && ((j = s + (k = n - i - 1)) < 0 || j >= nc || (cll = BidiClass.getBidiClass(chl = ca[j])) == 14 || ArabicScriptProcessor.isZWJ(chl)); ++i) {
        }
        if (cll != 5) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateFinal(chl);
    }

    private static boolean forceFinalThisContext(int[] ca, int nc, int s, int e) {
        int k;
        int j;
        int chl = 0;
        int cll = 0;
        int n = e - s;
        for (int i = 0; i < n && ((j = s + (k = n - i - 1)) < 0 || j >= nc || (cll = BidiClass.getBidiClass(chl = ca[j])) == 14 || ArabicScriptProcessor.isZWJ(chl)); ++i) {
        }
        if (cll != 5) {
            return false;
        }
        return ArabicScriptProcessor.hasIsolateInitial(chl);
    }

    private static boolean hasFinalSucceedingContext(int[] ca, int nc, int s, int e) {
        int chs = 0;
        int cls = 0;
        int n = nc;
        for (int i = e; i < n && (cls = BidiClass.getBidiClass(chs = ca[i])) == 14; ++i) {
        }
        if (cls != 5) {
            return !ArabicScriptProcessor.isZWJ(chs);
        }
        return ArabicScriptProcessor.hasIsolateFinal(chs);
    }

    private static boolean hasInitialPrecedingContext(int[] ca, int nc, int s, int e) {
        int k;
        int chp = 0;
        int clp = 0;
        for (int i = s; i > 0 && ((k = i - 1) < 0 || k >= nc || (clp = BidiClass.getBidiClass(chp = ca[k])) == 14); --i) {
        }
        if (clp != 5) {
            return !ArabicScriptProcessor.isZWJ(chp);
        }
        return ArabicScriptProcessor.hasIsolateInitial(chp);
    }

    private static boolean hasInitialThisContext(int[] ca, int nc, int s, int e) {
        int k;
        int chf = 0;
        int clf = 0;
        int n = e - s;
        for (int i = 0; i < n && ((k = s + i) < 0 || k >= nc || (clf = BidiClass.getBidiClass(chf = ca[s + i])) == 14 || ArabicScriptProcessor.isZWJ(chf)); ++i) {
        }
        if (clf != 5) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateInitial(chf);
    }

    private static boolean hasInitialSucceedingContext(int[] ca, int nc, int s, int e) {
        int chs = 0;
        int cls = 0;
        int n = nc;
        for (int i = e; i < n && (cls = BidiClass.getBidiClass(chs = ca[i])) == 14; ++i) {
        }
        if (cls != 5) {
            return ArabicScriptProcessor.isZWJ(chs);
        }
        return !ArabicScriptProcessor.hasIsolateFinal(chs);
    }

    private static boolean hasMedialPrecedingContext(int[] ca, int nc, int s, int e) {
        int k;
        int chp = 0;
        int clp = 0;
        for (int i = s; i > 0 && ((k = i - 1) < 0 || k >= nc || (clp = BidiClass.getBidiClass(chp = ca[k])) == 14); --i) {
        }
        if (clp != 5) {
            return ArabicScriptProcessor.isZWJ(chp);
        }
        return !ArabicScriptProcessor.hasIsolateInitial(chp);
    }

    private static boolean hasMedialThisContext(int[] ca, int nc, int s, int e) {
        int k;
        int j;
        int k2;
        int chf = 0;
        int clf = 0;
        int n = e - s;
        for (int i = 0; i < n && ((k2 = s + i) < 0 || k2 >= nc || (clf = BidiClass.getBidiClass(chf = ca[s + i])) == 14 || ArabicScriptProcessor.isZWJ(chf)); ++i) {
        }
        if (clf != 5) {
            return false;
        }
        int chl = 0;
        int cll = 0;
        int n2 = e - s;
        for (int i = 0; i < n2 && ((j = s + (k = n2 - i - 1)) < 0 || j >= nc || (cll = BidiClass.getBidiClass(chl = ca[j])) == 14 || ArabicScriptProcessor.isZWJ(chl)); ++i) {
        }
        if (cll != 5) {
            return false;
        }
        if (ArabicScriptProcessor.hasIsolateFinal(chf)) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateInitial(chl);
    }

    private static boolean hasMedialSucceedingContext(int[] ca, int nc, int s, int e) {
        int chs = 0;
        int cls = 0;
        int n = nc;
        for (int i = e; i < n && (cls = BidiClass.getBidiClass(chs = ca[i])) == 14; ++i) {
        }
        if (cls != 5) {
            return ArabicScriptProcessor.isZWJ(chs);
        }
        return !ArabicScriptProcessor.hasIsolateFinal(chs);
    }

    private static boolean hasLigaturePrecedingContext(int[] ca, int nc, int s, int e) {
        return true;
    }

    private static boolean hasLigatureSucceedingContext(int[] ca, int nc, int s, int e) {
        int chs = 0;
        int cls = 0;
        int n = nc;
        for (int i = e; i < n && (cls = BidiClass.getBidiClass(chs = ca[i])) == 14; ++i) {
        }
        return cls == 5;
    }

    private static boolean hasIsolateInitial(int ch) {
        return Arrays.binarySearch(ISOLATED_INITIALS, ch) >= 0;
    }

    private static boolean hasIsolateFinal(int ch) {
        return Arrays.binarySearch(ISOLATED_FINALS, ch) >= 0;
    }

    private static boolean isZWJ(int ch) {
        return ch == 8205;
    }

    private static class SubstitutionScriptContextTester
    implements ScriptContextTester {
        private static Map<String, GlyphContextTester> testerMap = new HashMap<String, GlyphContextTester>();

        private SubstitutionScriptContextTester() {
        }

        @Override
        public GlyphContextTester getTester(String feature) {
            return testerMap.get(feature);
        }

        static {
            testerMap.put("fina", new GlyphContextTester(){

                @Override
                public boolean test(String script, String language, String feature, GlyphSequence gs, int index, int flags) {
                    return ArabicScriptProcessor.inFinalContext(script, language, feature, gs, index, flags);
                }
            });
            testerMap.put("init", new GlyphContextTester(){

                @Override
                public boolean test(String script, String language, String feature, GlyphSequence gs, int index, int flags) {
                    return ArabicScriptProcessor.inInitialContext(script, language, feature, gs, index, flags);
                }
            });
            testerMap.put("isol", new GlyphContextTester(){

                @Override
                public boolean test(String script, String language, String feature, GlyphSequence gs, int index, int flags) {
                    return ArabicScriptProcessor.inIsolateContext(script, language, feature, gs, index, flags);
                }
            });
            testerMap.put("liga", new GlyphContextTester(){

                @Override
                public boolean test(String script, String language, String feature, GlyphSequence gs, int index, int flags) {
                    return ArabicScriptProcessor.inLigatureContext(script, language, feature, gs, index, flags);
                }
            });
            testerMap.put("medi", new GlyphContextTester(){

                @Override
                public boolean test(String script, String language, String feature, GlyphSequence gs, int index, int flags) {
                    return ArabicScriptProcessor.inMedialContext(script, language, feature, gs, index, flags);
                }
            });
        }
    }

    private static class PositioningScriptContextTester
    implements ScriptContextTester {
        private static Map<String, GlyphContextTester> testerMap = new HashMap<String, GlyphContextTester>();

        private PositioningScriptContextTester() {
        }

        @Override
        public GlyphContextTester getTester(String feature) {
            return testerMap.get(feature);
        }
    }
}

