/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.ResourceBundleWithFallback;

final class ResourceBundleTools {
    private ResourceBundleTools() {
    }

    public static ResourceBundle getMessageBundle() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.languagetool.MessagesBundle");
            ResourceBundle fallbackBundle = ResourceBundle.getBundle("org.languagetool.MessagesBundle", Locale.ENGLISH);
            return new ResourceBundleWithFallback(bundle, fallbackBundle);
        }
        catch (MissingResourceException e) {
            return ResourceBundle.getBundle("org.languagetool.MessagesBundle", Locale.ENGLISH);
        }
    }

    static ResourceBundle getMessageBundle(Language lang) {
        try {
            Language defaultVariant;
            ResourceBundle bundle = ResourceBundle.getBundle("org.languagetool.MessagesBundle", lang.getLocaleWithCountryAndVariant());
            if (!ResourceBundleTools.isValidBundleFor(lang, bundle) && !ResourceBundleTools.isValidBundleFor(lang, bundle = ResourceBundle.getBundle("org.languagetool.MessagesBundle", lang.getLocale())) && (defaultVariant = lang.getDefaultLanguageVariant()) != null && defaultVariant.getCountries().length > 0) {
                Locale locale = new Locale(defaultVariant.getShortCode(), defaultVariant.getCountries()[0]);
                bundle = ResourceBundle.getBundle("org.languagetool.MessagesBundle", locale);
            }
            ResourceBundle fallbackBundle = ResourceBundle.getBundle("org.languagetool.MessagesBundle", Locale.ENGLISH);
            return new ResourceBundleWithFallback(bundle, fallbackBundle);
        }
        catch (MissingResourceException e) {
            return ResourceBundle.getBundle("org.languagetool.MessagesBundle", Locale.ENGLISH);
        }
    }

    private static boolean isValidBundleFor(Language lang, ResourceBundle bundle) {
        return lang.getLocale().getLanguage().equals(bundle.getLocale().getLanguage());
    }
}

