/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.tokenizer.pipe;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.tokenizer.lexical.LexicalAnalyzer;
import com.hankcs.hanlp.tokenizer.pipe.LexicalAnalyzerPipe;
import com.hankcs.hanlp.tokenizer.pipe.Pipe;
import com.hankcs.hanlp.tokenizer.pipe.Pipeline;
import java.util.LinkedList;
import java.util.List;

public class LexicalAnalyzerPipeline
extends Pipeline<String, List<IWord>, List<IWord>>
implements LexicalAnalyzer {
    public LexicalAnalyzerPipeline(Pipe<String, List<IWord>> first, Pipe<List<IWord>, List<IWord>> last) {
        super(first, last);
    }

    public LexicalAnalyzerPipeline(LexicalAnalyzer analyzer) {
        this(new LexicalAnalyzerPipe(analyzer));
    }

    public LexicalAnalyzerPipeline(LexicalAnalyzerPipe analyzer) {
        this(new Pipe<String, List<IWord>>(){

            @Override
            public List<IWord> flow(String input) {
                LinkedList<IWord> output = new LinkedList<IWord>();
                output.add(new Word(input, null));
                return output;
            }
        }, new Pipe<List<IWord>, List<IWord>>(){

            @Override
            public List<IWord> flow(List<IWord> input) {
                return input;
            }
        });
        this.add(analyzer);
    }

    public LexicalAnalyzer getAnalyzer() {
        for (Pipe pipe : this) {
            if (!(pipe instanceof LexicalAnalyzerPipe)) continue;
            return ((LexicalAnalyzerPipe)pipe).analyzer;
        }
        return null;
    }

    @Override
    public void segment(String sentence, String normalized, List<String> wordList) {
        LexicalAnalyzer analyzer = this.getAnalyzer();
        if (analyzer == null) {
            throw new IllegalStateException("\u6d41\u6c34\u7ebf\u4e2d\u6ca1\u6709LexicalAnalyzerPipe");
        }
        analyzer.segment(sentence, normalized, wordList);
    }

    @Override
    public List<String> segment(String sentence) {
        LexicalAnalyzer analyzer = this.getAnalyzer();
        if (analyzer == null) {
            throw new IllegalStateException("\u6d41\u6c34\u7ebf\u4e2d\u6ca1\u6709LexicalAnalyzerPipe");
        }
        return analyzer.segment(sentence);
    }

    @Override
    public String[] recognize(String[] wordArray, String[] posArray) {
        LexicalAnalyzer analyzer = this.getAnalyzer();
        if (analyzer == null) {
            throw new IllegalStateException("\u6d41\u6c34\u7ebf\u4e2d\u6ca1\u6709LexicalAnalyzerPipe");
        }
        return analyzer.recognize(wordArray, posArray);
    }

    @Override
    public String[] tag(String ... words) {
        LexicalAnalyzer analyzer = this.getAnalyzer();
        if (analyzer == null) {
            throw new IllegalStateException("\u6d41\u6c34\u7ebf\u4e2d\u6ca1\u6709LexicalAnalyzerPipe");
        }
        return analyzer.tag(words);
    }

    @Override
    public String[] tag(List<String> wordList) {
        LexicalAnalyzer analyzer = this.getAnalyzer();
        if (analyzer == null) {
            throw new IllegalStateException("\u6d41\u6c34\u7ebf\u4e2d\u6ca1\u6709LexicalAnalyzerPipe");
        }
        return analyzer.tag(wordList);
    }

    @Override
    public NERTagSet getNERTagSet() {
        LexicalAnalyzer analyzer = this.getAnalyzer();
        if (analyzer == null) {
            throw new IllegalStateException("\u6d41\u6c34\u7ebf\u4e2d\u6ca1\u6709LexicalAnalyzerPipe");
        }
        return analyzer.getNERTagSet();
    }

    @Override
    public Sentence analyze(String sentence) {
        return new Sentence((List)this.flow(sentence));
    }
}

