/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import net.sourceforge.offroad.ui.ColorUtils;

public class Paint {
    private boolean mAntialias;
    private Style mStrokeStyle;
    private boolean mFilterBitmap;
    private boolean mDither;
    private float mTextSize;
    private Align mTextAlign;
    private boolean mFakeBoldText;
    private Color mColor;
    private Composite mCompositeFilter;
    private Object mShader;
    private boolean mClearShadowLayer;
    private TexturePaint mTexturePaint;
    private float mStrokeWidth = 2.0f;
    private Stroke mStroke;
    private boolean mFilterBufferedImage;

    public void setAntiAlias(boolean pAntialias) {
        this.mAntialias = pAntialias;
    }

    public void setStyle(Style pStrokeStyle) {
        this.mStrokeStyle = pStrokeStyle;
    }

    public void setFilterBitmap(boolean pFilterBitmap) {
        this.mFilterBitmap = pFilterBitmap;
    }

    public void setDither(boolean pDither) {
        this.mDither = pDither;
    }

    public void setTextSize(float pTextSize) {
        this.mTextSize = pTextSize;
    }

    public void setTextAlign(Align pAlign) {
        this.mTextAlign = pAlign;
    }

    public void setFakeBoldText(boolean pFakeBoldText) {
        this.mFakeBoldText = pFakeBoldText;
    }

    public void setColor(Color pColor) {
        this.mColor = pColor;
    }

    public void setColor(int pColor) {
        this.mColor = ColorUtils.create(pColor);
    }

    public void setColorFilter(Composite pCompositeFilter) {
        this.mCompositeFilter = pCompositeFilter;
    }

    public void setShader(Object pShader) {
        this.mShader = pShader;
    }

    public void clearShadowLayer() {
        this.mClearShadowLayer = true;
    }

    public void setPaint(TexturePaint pTexturePaint) {
        this.mTexturePaint = pTexturePaint;
    }

    public void setStrokeWidth(float pStrokeWidth) {
        this.mStrokeWidth = pStrokeWidth;
    }

    public Graphics2D updateGraphics(Graphics2D g2) {
        if (this.mCompositeFilter != null) {
            g2.setComposite(this.mCompositeFilter);
        }
        if (this.mColor != null) {
            g2.setColor(this.mColor);
        }
        if (this.mStroke != null) {
            g2.setStroke(this.mStroke);
        } else {
            g2.setStroke(new BasicStroke(this.mStrokeWidth));
        }
        if (this.mTexturePaint != null) {
            g2.setPaint(this.mTexturePaint);
        }
        if (this.mAntialias) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Font oldFont = g2.getFont();
        if (this.mTextSize != 0.0f) {
            g2.setFont(new Font(oldFont.getFontName(), oldFont.getStyle(), (int)this.mTextSize));
        }
        return g2;
    }

    public void setStroke(Stroke pDashEffect) {
        this.mStroke = pDashEffect;
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public int getColor() {
        return this.mColor.getRGB() + this.mColor.getAlpha() << 24;
    }

    public Color getColorAsColor() {
        return this.mColor;
    }

    public void setFilterBufferedImage(boolean pFilterBufferedImage) {
        this.mFilterBufferedImage = pFilterBufferedImage;
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum Style {
        STROKE,
        FILL_AND_STROKE,
        FILL;

    }
}

