/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.resources;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.GeocodingUtilities;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Street;
import net.osmand.util.MapUtils;

public interface RegionAddressRepository {
    public String getName();

    public String getFileName();

    public String getLang();

    public LatLon getEstimatedRegionCenter();

    public void clearCache();

    public void close();

    public void preloadCities(ResultMatcher<City> var1);

    public void preloadBuildings(Street var1, ResultMatcher<Building> var2);

    public void preloadStreets(City var1, ResultMatcher<Street> var2);

    public List<City> getLoadedCities();

    public City getCityById(long var1, String var3);

    public Street getStreetByName(City var1, String var2);

    public Building getBuildingByName(Street var1, String var2);

    public List<Street> getStreetsIntersectStreets(Street var1);

    public void addCityToPreloadedList(City var1);

    public List<City> fillWithSuggestedCities(String var1, ResultMatcher<City> var2, boolean var3, LatLon var4);

    public List<MapObject> searchMapObjectsByName(String var1, ResultMatcher<MapObject> var2);

    public BinaryMapIndexReader getFile();

    public List<GeocodingUtilities.GeocodingResult> justifyReverseGeocodingSearch(GeocodingUtilities.GeocodingResult var1, double var2, ResultMatcher<GeocodingUtilities.GeocodingResult> var4);

    public static class MapObjectNameDistanceComparator
    implements Comparator<MapObject> {
        private Collator collator = Collator.getInstance();
        private final LatLon location;
        private final String lang;

        public MapObjectNameDistanceComparator(String lang, LatLon location) {
            this.lang = lang;
            this.location = location;
        }

        @Override
        public int compare(MapObject object1, MapObject object2) {
            if (object1 == null || object2 == null) {
                return object2 == object1 ? 0 : (object1 == null ? -1 : 1);
            }
            int c = this.collator.compare(object1.getName(this.lang), object2.getName(this.lang));
            if (c == 0 && this.location != null) {
                LatLon l1 = object1.getLocation();
                LatLon l2 = object2.getLocation();
                if (l1 == null || l2 == null) {
                    return l2 == l1 ? 0 : (l1 == null ? -1 : 1);
                }
                return Double.compare(MapUtils.getDistance(this.location, l1), MapUtils.getDistance(this.location, l2));
            }
            return c;
        }
    }
}

