/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.sdedit.util.ObjectFactory;

public class Grep {
    private final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();
    private final Map<Class<?>, Map<String, PropertyDescriptor>> descriptorCache = new HashMap();
    private final Unescape unescape;
    public static Unescape NO_UNESCAPE = null;
    public static Unescape DEFAULT_UNESCAPE = new Unescape(){

        @Override
        public final String unescape(String string) {
            if (string == null) {
                return null;
            }
            StringBuilder unescaped = new StringBuilder();
            int state = 0;
            block4: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (state) {
                    case 0: {
                        if (c != '\\') {
                            unescaped.append(c);
                            continue block4;
                        }
                        state = 1;
                        continue block4;
                    }
                    case 1: {
                        unescaped.append(c);
                        state = 0;
                        continue block4;
                    }
                }
            }
            if (state == 1) {
                unescaped.append('\\');
            }
            return unescaped.toString();
        }
    };

    public Grep(Unescape unescape) {
        this.unescape = unescape;
    }

    private Pattern getPattern(String regexp) {
        Pattern pattern = this.patternCache.get(regexp);
        if (pattern == null) {
            pattern = Pattern.compile(regexp);
            this.patternCache.put(regexp, pattern);
        }
        return pattern;
    }

    public String[] parse(String regexp, String string) {
        return this.parse(regexp, string, null);
    }

    public String[] parse(Pattern pattern, String string) {
        return this.parse(pattern, string, null);
    }

    public String[] parse(String regexp, String string, List<Region> regions) {
        return this.parse(this.getPattern(regexp), string, regions);
    }

    public String[] parse(Pattern pattern, String string, List<Region> regions) {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String[] groups = new String[matcher.groupCount()];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = this.unescape != null ? this.unescape.unescape(matcher.group(i + 1)) : matcher.group(i + 1);
            if (regions == null) continue;
            regions.add(new Region(matcher.group(i + 1), matcher.start(i + 1), matcher.end(i + 1)));
        }
        return groups;
    }

    public boolean parseAndSetProperties(Object bean, String regexp, String string, Map<String, Region> propertyRegions, String ... properties) {
        return this.parseAndSetProperties(bean, this.getPattern(regexp), string, propertyRegions, properties);
    }

    public boolean parseAndSetProperties(Object bean, Pattern pattern, String string, Map<String, Region> propertyRegions, String ... properties) {
        String[] parsed;
        ArrayList<Region> regions = null;
        if (propertyRegions != null) {
            regions = new ArrayList<Region>();
        }
        if ((parsed = this.parse(pattern, string, regions)) == null) {
            return false;
        }
        if (properties.length != parsed.length) {
            throw new IllegalArgumentException("number of groups does not match number of properties");
        }
        Map<String, PropertyDescriptor> descriptors = this.descriptorCache.get(bean.getClass());
        if (descriptors == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(bean.getClass());
            }
            catch (IntrospectionException ie) {
                throw new IllegalStateException("Cannot introspect " + bean.getClass().getName(), ie);
            }
            descriptors = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                if (descriptor.getWriteMethod() == null) continue;
                descriptors.put(descriptor.getName(), descriptor);
            }
            this.descriptorCache.put(bean.getClass(), descriptors);
        }
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor pd = descriptors.get(properties[i]);
            if (pd == null) {
                throw new IllegalArgumentException("property " + properties[i] + " does not exist");
            }
            if (propertyRegions != null) {
                propertyRegions.put(pd.getName(), regions.get(i));
            }
            Object value = ObjectFactory.createFromString(pd.getPropertyType(), parsed[i]);
            try {
                pd.getWriteMethod().invoke(bean, value);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("cannot write property " + properties[i]);
            }
        }
        return true;
    }

    public static class Region {
        private final int start;
        private final int end;
        private final String text;

        protected Region(String text, int start, int end) {
            this.start = start;
            this.end = end;
            this.text = text;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getText() {
            return this.text;
        }
    }

    public static interface Unescape {
        public String unescape(String var1);
    }
}

