/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import javax.swing.JComponent;
import org.coode.mdock.ComponentNode;
import org.coode.mdock.Node;
import org.coode.mdock.Splitter;
import org.coode.mdock.SplitterNode;
import org.coode.mdock.Util;

public class NodeLayout
implements LayoutManager2 {
    private Node rootNode;
    private int preferredWidth = 800;
    private int preferredHeight = 600;

    public NodeLayout(Node rootNode) {
        this.rootNode = rootNode;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(10, 10);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layoutNode(this.rootNode, parent);
    }

    private void layoutNode(Node node, Container parent) {
        if (node instanceof ComponentNode) {
            ComponentNode componentNode = (ComponentNode)node;
            JComponent comp = componentNode.getComponent();
            comp.setBounds(Util.getBounds(node, parent, true));
        } else {
            SplitterNode splitterNode = (SplitterNode)node;
            for (Splitter splitter : splitterNode.getSplitters()) {
                splitter.resetBounds();
            }
            for (Node curChild : splitterNode.getVisibleChildren()) {
                this.layoutNode(curChild, parent);
            }
        }
    }
}

