/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover.thread;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public abstract class TerminableRunnable
implements Runnable {
    private final AtomicReference<State> runState = new AtomicReference<State>(State.IDLE);
    private final AtomicBoolean unschedule = new AtomicBoolean();
    private volatile ScheduledFuture<?> scheduledFuture = null;

    public TerminableRunnable(ScheduledExecutorService scheduler, long initialDelay, long delay, TimeUnit unit) {
        this.scheduledFuture = scheduler.scheduleWithFixedDelay(this, initialDelay, delay, unit);
    }

    protected abstract void doRun();

    @Override
    public final void run() {
        if (!this.runState.compareAndSet(State.IDLE, State.ACTIVE)) {
            return;
        }
        try {
            this.doRun();
        }
        finally {
            this.runState.compareAndSet(State.ACTIVE, State.IDLE);
        }
    }

    public void blockTillTerminated() {
        while (!this.runState.compareAndSet(State.IDLE, State.REMOVED)) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            if (!Thread.currentThread().isInterrupted()) continue;
            this.runState.set(State.REMOVED);
            return;
        }
    }

    public boolean isUnschedule() {
        return this.unschedule.get();
    }

    public void unscheduleTask() {
        if (this.unschedule.compareAndSet(false, true)) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    private static enum State {
        REMOVED,
        IDLE,
        ACTIVE;

    }
}

