/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class SerializableParameter
implements Cloneable,
ParameterHolder {
    private final boolean noBackSlashEscapes;
    private Object object;
    private byte[] loadedStream = null;

    public SerializableParameter(Object object, boolean noBackslashEscapes) {
        this.object = object;
        this.noBackSlashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        if (this.loadedStream == null) {
            this.writeObjectToBytes();
        }
        pos.write(BINARY_INTRODUCER);
        pos.writeBytesEscaped(this.loadedStream, this.loadedStream.length, this.noBackSlashEscapes);
        pos.write(39);
    }

    private void writeObjectToBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.object);
        this.loadedStream = baos.toByteArray();
        this.object = null;
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        this.writeObjectToBytes();
        return this.loadedStream.length;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        if (this.loadedStream == null) {
            this.writeObjectToBytes();
        }
        pos.writeFieldLength(this.loadedStream.length);
        pos.write(this.loadedStream);
    }

    @Override
    public String toString() {
        return "<Serializable>";
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.BLOB;
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

