/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.TeXCellAlign;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HAlignRow;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import java.io.IOException;
import java.util.ArrayDeque;

public class L2HMathAlignRow
extends L2HAlignRow {
    private boolean isNumbered;
    private ArrayDeque<HtmlTag> tags = new ArrayDeque();

    public L2HMathAlignRow(boolean bl) {
        this.isNumbered = bl;
    }

    public L2HMathAlignRow(int n, boolean bl) {
        super(n);
        this.isNumbered = bl;
    }

    public L2HMathAlignRow(TeXParser teXParser, TeXObjectList teXObjectList, boolean bl) throws IOException {
        this(bl);
        this.parse(teXParser, teXObjectList);
    }

    @Override
    protected void processCell(TeXParser teXParser, TeXCellAlign teXCellAlign, Group group) throws IOException {
        for (int i = group.size() - 1; i >= 0; --i) {
            TeXObject teXObject = (TeXObject)group.get(i);
            if (!(teXObject instanceof HtmlTag)) continue;
            group.remove(i);
            this.tags.push((HtmlTag)teXObject);
        }
        super.processCell(teXParser, teXCellAlign, group);
    }

    @Override
    protected void startRow(TeXParser teXParser) throws IOException {
        super.startRow(teXParser);
        teXParser.getListener().getWriteable().write("<td style=\"width: 50%; \"></td>");
    }

    @Override
    protected void endRow(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (this.isNumbered) {
            l2HConverter.stepcounter("equation");
            l2HConverter.write("<td style=\"width: 50%; align: right;\"><span class=\"eqno\">(");
            l2HConverter.getControlSequence("theequation").process(teXParser);
            l2HConverter.write(")</span></td>");
        } else {
            l2HConverter.write("<td style=\"width: 50%; \"></td>");
        }
        super.endRow(teXParser);
    }

    @Override
    public TeXDimension getDefaultColSep(TeXParser teXParser) throws TeXSyntaxException {
        Register register = teXParser.getSettings().getRegister("arraycolsep");
        if (register == null || !(register instanceof DimenRegister)) {
            throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", String.format("%sarraycolsep", new String(Character.toChars(teXParser.getEscChar()))));
        }
        return ((DimenRegister)register).getDimension();
    }

    @Override
    protected void startCell(TeXParser teXParser, String string, String string2) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        super.startCell(teXParser, string, string2);
        if (l2HConverter.useMathJax()) {
            l2HConverter.write(l2HConverter.mathJaxStartInline() + "\\displaystyle ");
        }
    }

    @Override
    protected void endCell(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (l2HConverter.useMathJax()) {
            l2HConverter.write(l2HConverter.mathJaxEndInline());
        }
        while (this.tags.size() > 0) {
            this.tags.pop().process(teXParser);
        }
        super.endCell(teXParser);
    }
}

