/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.print.BufferPrintable1_7;
import org.gjt.sp.jedit.print.PrintPreviewModel;
import org.gjt.sp.jedit.print.PrintRangeType;
import org.gjt.sp.jedit.print.PrinterDialog;
import org.gjt.sp.jedit.print.Range;
import org.gjt.sp.jedit.print.Reverse;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class BufferPrinter1_7 {
    private static PrintRequestAttributeSet format;
    private static DocPrintJob job;

    public static void pageSetup(View view) {
        BufferPrinter1_7.loadPrintSpec();
        PrinterDialog printerDialog = new PrinterDialog(view, format, true);
        if (!printerDialog.isCanceled()) {
            format = printerDialog.getAttributes();
            BufferPrinter1_7.savePrintSpec();
            EditBus.send(new PropertiesChanged(null));
        }
    }

    public static void print(final View view, Buffer buffer) {
        Attribute[] attributeArray;
        Log.log(1, BufferPrinter1_7.class, "print buffer " + buffer.getPath());
        BufferPrinter1_7.loadPrintSpec();
        String string = MiscUtilities.abbreviateView(buffer.getPath());
        format.add(new JobName(string, null));
        PrinterDialog printerDialog = new PrinterDialog(view, format, false);
        if (printerDialog.isCanceled()) {
            Log.log(1, BufferPrinter1_7.class, "print dialog canceled");
            return;
        }
        PrintService printService = printerDialog.getPrintService();
        if (printService != null) {
            try {
                job = printService.createPrintJob();
                job.addPrintJobListener(new JobListener(view));
                format = printerDialog.getAttributes();
                BufferPrinter1_7.savePrintSpec();
                EditBus.send(new PropertiesChanged(null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(view, jEdit.getProperty("print-error.message", new String[]{exception.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                return;
            }
        } else {
            JOptionPane.showMessageDialog(view, jEdit.getProperty("print-error.message", new String[]{"Invalid print service."}), jEdit.getProperty("print-error.title"), 0);
            return;
        }
        Buffer buffer2 = buffer;
        PrintRangeType printRangeType = (PrintRangeType)format.get(PrintRangeType.class);
        if (PrintRangeType.SELECTION.equals(printRangeType)) {
            buffer2 = BufferPrinter1_7.getSelectionBuffer(view, buffer);
        }
        HashDocAttributeSet hashDocAttributeSet = new HashDocAttributeSet();
        for (Attribute attribute : attributeArray = format.toArray()) {
            boolean bl = attribute instanceof DocAttribute;
            if (!bl) continue;
            hashDocAttributeSet.add(attribute);
        }
        BufferPrintable1_7 bufferPrintable1_7 = new BufferPrintable1_7(format, view, buffer2);
        final SimpleDoc simpleDoc = new SimpleDoc(bufferPrintable1_7, DocFlavor.SERVICE_FORMATTED.PRINTABLE, hashDocAttributeSet);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    job.print(simpleDoc, format);
                }
                catch (PrintException printException) {
                    JOptionPane.showMessageDialog(view, jEdit.getProperty("print-error.message", new String[]{printException.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                }
            }
        };
        ThreadUtilities.runInBackground(runnable);
    }

    private static Buffer getSelectionBuffer(View view, Buffer buffer) {
        int[] nArray = view.getTextArea().getSelectedLines();
        String string = buffer.getPath();
        String string2 = string.substring(0, string.lastIndexOf(System.getProperty("file.separator")));
        Buffer buffer2 = jEdit.openTemporary(view, string2, string + ".prn", true);
        buffer2.setMode(buffer.getMode());
        for (int n : nArray) {
            String string3 = buffer.getLineText(n) + '\n';
            buffer2.insert(buffer2.getLength(), string3);
        }
        buffer2.setProperty("printingLineNumbers", nArray);
        return buffer2;
    }

    protected static void printPage(PrintPreviewModel printPreviewModel) {
        PrintService printService;
        String string = MiscUtilities.abbreviateView(printPreviewModel.getBuffer().getPath());
        PrintRequestAttributeSet printRequestAttributeSet = printPreviewModel.getAttributes();
        printRequestAttributeSet.add(new JobName(string, null));
        Reverse reverse = (Reverse)printRequestAttributeSet.get(Reverse.class);
        if (reverse != null) {
            printRequestAttributeSet.remove(Reverse.class);
        }
        if ((printService = printPreviewModel.getPrintService()) == null) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        }
        if (printService != null) {
            try {
                job = printService.createPrintJob();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(printPreviewModel.getView(), jEdit.getProperty("print-error.message", new String[]{exception.getMessage()}), jEdit.getProperty("print-error.title"), 0);
                return;
            }
        } else {
            JOptionPane.showMessageDialog(printPreviewModel.getView(), jEdit.getProperty("print-error.message", new String[]{"Invalid print service."}), jEdit.getProperty("print-error.title"), 0);
            return;
        }
        Buffer buffer = printPreviewModel.getBuffer();
        PrintRangeType printRangeType = (PrintRangeType)printRequestAttributeSet.get(PrintRangeType.class);
        if (PrintRangeType.SELECTION.equals(printRangeType)) {
            buffer = BufferPrinter1_7.getSelectionBuffer(printPreviewModel.getView(), buffer);
        }
        BufferPrintable1_7 bufferPrintable1_7 = new BufferPrintable1_7(printRequestAttributeSet, printPreviewModel.getView(), buffer);
        bufferPrintable1_7.setPages(printPreviewModel.getPageRanges());
        int n = printPreviewModel.getPageNumber();
        try {
            bufferPrintable1_7.print(printPreviewModel.getGraphics(), printPreviewModel, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (reverse != null) {
            printRequestAttributeSet.add(reverse);
        }
    }

    public static HashMap<Integer, Range> getPageRanges(View view, Buffer buffer, PrintRequestAttributeSet printRequestAttributeSet) {
        BufferPrinter1_7.loadPrintSpec();
        format.addAll(printRequestAttributeSet);
        BufferPrintable1_7 bufferPrintable1_7 = new BufferPrintable1_7(format, view, buffer);
        return BufferPrinter1_7.getPageRanges(bufferPrintable1_7, format);
    }

    private static HashMap<Integer, Range> getPageRanges(BufferPrintable1_7 bufferPrintable1_7, PrintRequestAttributeSet printRequestAttributeSet) {
        PageFormat pageFormat = BufferPrinter1_7.createPageFormat(printRequestAttributeSet);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        BufferedImage bufferedImage = new BufferedImage(new Double(pageFormat.getImageableWidth()).intValue(), new Double(pageFormat.getImageableHeight()).intValue(), 1);
        Graphics2D graphics2D = graphicsEnvironment.createGraphics(bufferedImage);
        Paper paper = pageFormat.getPaper();
        Rectangle2D.Double double_ = new Rectangle2D.Double(paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), paper.getImageableHeight());
        graphics2D.setClip(double_);
        try {
            HashMap<Integer, Range> hashMap = bufferPrintable1_7.calculatePages(graphics2D, pageFormat);
            PageRanges pageRanges = (PageRanges)printRequestAttributeSet.get(PageRanges.class);
            if (pageRanges == null) {
                pageRanges = new PageRanges(1, 1000);
            }
            HashMap<Integer, Range> hashMap2 = new HashMap<Integer, Range>();
            for (Integer n : hashMap.keySet()) {
                if (!pageRanges.contains(n)) continue;
                hashMap2.put(n, hashMap.get(n));
            }
            return hashMap2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static HashMap<Integer, Range> getCurrentPageRange(View view, Buffer buffer, PrintRequestAttributeSet printRequestAttributeSet) {
        if (printRequestAttributeSet == null) {
            BufferPrinter1_7.loadPrintSpec();
            printRequestAttributeSet = format;
        }
        BufferPrintable1_7 bufferPrintable1_7 = new BufferPrintable1_7(printRequestAttributeSet, view, buffer);
        HashMap<Integer, Range> hashMap = BufferPrinter1_7.getPageRanges(bufferPrintable1_7, printRequestAttributeSet);
        HashMap<Integer, Range> hashMap2 = new HashMap<Integer, Range>();
        int n = view.getTextArea().getCaretLine();
        for (Integer n2 : hashMap.keySet()) {
            Range range = hashMap.get(n2);
            if (!range.contains(n)) continue;
            hashMap2.put(n2, range);
            break;
        }
        return hashMap2;
    }

    public static PageFormat getDefaultPageFormat(PrintRequestAttributeSet printRequestAttributeSet) {
        return BufferPrinter1_7.createPageFormat(printRequestAttributeSet);
    }

    private static PageFormat createPageFormat(PrintRequestAttributeSet printRequestAttributeSet) {
        Paper paper = new Paper();
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
        int n = 25400;
        double d = 72.0;
        double d2 = (double)mediaPrintableArea.getX(n) * d;
        double d3 = (double)mediaPrintableArea.getY(n) * d;
        double d4 = (double)mediaPrintableArea.getWidth(n) * d;
        double d5 = (double)mediaPrintableArea.getHeight(n) * d;
        paper.setImageableArea(d2, d3, d4, d5);
        int n2 = 1;
        OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
        if (OrientationRequested.LANDSCAPE.equals(orientationRequested) || OrientationRequested.REVERSE_LANDSCAPE.equals(orientationRequested)) {
            n2 = 0;
        }
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(n2);
        return pageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPrintSpec() {
        Object object;
        File file;
        format = new HashPrintRequestAttributeSet();
        String string = jEdit.getSettingsDirectory();
        if (string != null && (file = new File((String)(object = MiscUtilities.constructPath(string, "printspec")))).exists()) {
            ObjectInputStream objectInputStream = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(fileInputStream);
                format = (HashPrintRequestAttributeSet)objectInputStream.readObject();
            }
            catch (Exception exception) {
                Log.log(9, BufferPrinter1_7.class, exception);
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((object = (MediaPrintableArea)format.get(MediaPrintableArea.class)) == null) {
            object = new MediaPrintableArea(0.5f, 0.5f, 10.0f, 7.5f, 25400);
            format.add((Attribute)object);
        }
        format.remove(Reverse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePrintSpec() {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return;
        }
        String string2 = MiscUtilities.constructPath(string, "printspec");
        File file = new File(string2);
        ObjectOutputStream objectOutputStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(format);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.flush();
                }
                catch (IOException iOException) {}
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class JobListener
    extends PrintJobAdapter {
        private View view;

        public JobListener(View view) {
            this.view = view;
        }

        @Override
        public void printJobCompleted(PrintJobEvent printJobEvent) {
            PrintService printService = printJobEvent.getPrintJob().getPrintService();
            if (printService instanceof StreamPrintService) {
                StreamPrintService streamPrintService = (StreamPrintService)printService;
                OutputStream outputStream = streamPrintService.getOutputStream();
                try {
                    outputStream.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.view.getStatus().setMessageAndClear("Printing complete.");
        }

        @Override
        public void printJobFailed(PrintJobEvent printJobEvent) {
            JOptionPane.showMessageDialog(this.view, jEdit.getProperty("print-error.message", new String[]{"Print job failed."}), jEdit.getProperty("print-error.title"), 0);
        }

        @Override
        public void printJobRequiresAttention(PrintJobEvent printJobEvent) {
            JOptionPane.showMessageDialog(this.view, jEdit.getProperty("print-error.message", new String[]{"Check the printer."}), jEdit.getProperty("print-error.title"), 0);
        }
    }
}

