/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;

class DataSourceDataContentHandler
implements DataContentHandler {
    private DataSource ds;
    private DataFlavor[] flavors;
    private DataContentHandler dch;

    public DataSourceDataContentHandler(DataContentHandler dataContentHandler, DataSource dataSource) {
        this.ds = dataSource;
        this.dch = dataContentHandler;
    }

    @Override
    public Object getContent(DataSource dataSource) throws IOException {
        if (this.dch != null) {
            return this.dch.getContent(dataSource);
        }
        return dataSource.getInputStream();
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws UnsupportedFlavorException, IOException {
        if (this.dch != null) {
            return this.dch.getTransferData(dataFlavor, dataSource);
        }
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        if (dataFlavorArray.length > 0 && dataFlavor.equals(dataFlavorArray[0])) {
            return dataSource.getInputStream();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.flavors == null) {
            if (this.dch != null) {
                this.flavors = this.dch.getTransferDataFlavors();
            } else {
                String string = this.ds.getContentType();
                this.flavors = new DataFlavor[1];
                this.flavors[0] = new ActivationDataFlavor(string, string);
            }
        }
        return this.flavors;
    }

    @Override
    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (this.dch == null) {
            throw new UnsupportedDataTypeException("no DCH for content type " + this.ds.getContentType());
        }
        this.dch.writeTo(object, string, outputStream);
    }
}

