/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import gnu.inet.imap.IMAPConnection;
import gnu.inet.imap.Namespaces;
import gnu.inet.imap.UTF7imap;
import java.util.ArrayList;
import java.util.List;

public class Quota {
    String quotaRoot;
    List resources;

    Quota(String string) {
        int n = string.length();
        ArrayList arrayList = new ArrayList();
        Namespaces.parse(string, 0, n, arrayList);
        this.quotaRoot = (String)arrayList.get(0);
        this.resources = new ArrayList();
        n = arrayList.size();
        for (int i = 1; i < n; ++i) {
            this.resources.add(this.parseResource((List)arrayList.get(i)));
        }
    }

    private Resource parseResource(List list) {
        String string = (String)list.get(0);
        String string2 = (String)list.get(1);
        String string3 = (String)list.get(2);
        return new Resource(string, Integer.parseInt(string2), Integer.parseInt(string3));
    }

    public String getQuotaRoot() {
        return this.quotaRoot;
    }

    public Resource[] getResources() {
        Resource[] resourceArray = new Resource[this.resources.size()];
        this.resources.toArray(resourceArray);
        return resourceArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IMAPConnection.quote(UTF7imap.encode(this.quotaRoot)));
        int n = this.resources.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(this.resources.get(i));
        }
        return stringBuffer.toString();
    }

    public static class Resource {
        String name;
        int current;
        int limit;

        public Resource(String string, int n) {
            this(string, -1, n);
        }

        Resource(String string, int n, int n2) {
            this.name = string;
            this.current = n;
            this.limit = n2;
        }

        public String getName() {
            return this.name;
        }

        public int getCurrentUsage() {
            return this.current;
        }

        public int getLimit() {
            return this.limit;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            stringBuffer.append(this.name);
            if (this.current >= 0) {
                stringBuffer.append(' ');
                stringBuffer.append(this.current);
            }
            stringBuffer.append(' ');
            stringBuffer.append(this.limit);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

