/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.NavigationPage;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.InstrumentsDbFrame;
import org.jsampler.view.classic.Res;
import org.jsampler.view.std.JSDbSearchPane;

public class DbSearchPage
extends NavigationPage {
    private final DbSearchPane dbSearchPane;

    public DbSearchPage(final InstrumentsDbFrame instrumentsDbFrame) {
        this.setTitle(ClassicI18n.i18n.getLabel("DbSearchPage.title"));
        this.setLayout(new BorderLayout());
        this.dbSearchPane = new DbSearchPane(instrumentsDbFrame);
        this.dbSearchPane.setBackgroundColor(Color.WHITE);
        this.add(this.dbSearchPane);
        this.dbSearchPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                instrumentsDbFrame.setSearchResults(DbSearchPage.this.dbSearchPane.getDirectoryResults(), DbSearchPage.this.dbSearchPane.getInstrumentResults());
            }
        });
    }

    public void setSearchPath(String string) {
        this.dbSearchPane.setSearchPath(string);
    }

    class CriteriaPane
    extends JPanel {
        CriteriaPane(String string, final JComponent jComponent) {
            this.setOpaque(false);
            final JToggleButton jToggleButton = new JToggleButton();
            jToggleButton.setBorderPainted(false);
            jToggleButton.setContentAreaFilled(false);
            jToggleButton.setFocusPainted(false);
            jToggleButton.setIcon(Res.iconBack16);
            jToggleButton.setSelectedIcon(Res.iconDown16);
            jToggleButton.setMargin(new Insets(0, 0, 0, 0));
            jToggleButton.setCursor(Cursor.getPredefinedCursor(12));
            jToggleButton.setOpaque(false);
            JLabel jLabel = new JLabel(string);
            jLabel.setCursor(Cursor.getPredefinedCursor(12));
            int n = jLabel.getMaximumSize().height;
            Dimension dimension = new Dimension(Short.MAX_VALUE, n);
            jLabel.setMaximumSize(dimension);
            jLabel.setOpaque(false);
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(jLabel);
            jPanel.add(jToggleButton);
            this.add((Component)jPanel, "North");
            jPanel.setOpaque(false);
            jComponent.setVisible(false);
            this.add(jComponent);
            n = this.getMaximumSize().height;
            dimension = new Dimension(Short.MAX_VALUE, n);
            this.setMaximumSize(dimension);
            jToggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jComponent.setVisible(jToggleButton.isSelected());
                }
            });
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() != 1) {
                        return;
                    }
                    if (mouseEvent.getClickCount() != 1) {
                        return;
                    }
                    jToggleButton.doClick();
                }
            });
            n = this.getPreferredSize().height;
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, n));
            this.setAlignmentX(0.0f);
        }
    }

    class DbSearchPane
    extends JSDbSearchPane {
        DbSearchPane(Frame frame) {
            super(frame);
        }

        @Override
        protected JComponent createCriteriaPane(String string, JComponent jComponent) {
            return new CriteriaPane(string, jComponent);
        }
    }
}

