/*
 * Decompiled with CFR 0.152.
 */
package git4idea.validators;

import com.intellij.openapi.ui.InputValidatorEx;
import git4idea.GitBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class GitNewBranchNameValidator
implements InputValidatorEx {
    private final Collection<? extends GitRepository> myRepositories;
    private String myErrorText;

    private GitNewBranchNameValidator(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitNewBranchNameValidator.$$$reportNull$$$0(0);
        }
        this.myRepositories = repositories;
    }

    public static GitNewBranchNameValidator newInstance(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitNewBranchNameValidator.$$$reportNull$$$0(1);
        }
        return new GitNewBranchNameValidator(repositories);
    }

    public boolean checkInput(@NotNull String inputString) {
        if (inputString == null) {
            GitNewBranchNameValidator.$$$reportNull$$$0(2);
        }
        if (!GitRefNameValidator.getInstance().checkInput(inputString)) {
            this.myErrorText = "Invalid name for branch";
            return false;
        }
        return this.checkBranchConflict(inputString);
    }

    private boolean checkBranchConflict(@NotNull String inputString) {
        if (inputString == null) {
            GitNewBranchNameValidator.$$$reportNull$$$0(3);
        }
        if (this.isNotPermitted(inputString) || this.conflictsWithLocalBranch(inputString) || this.conflictsWithRemoteBranch(inputString)) {
            return false;
        }
        this.myErrorText = null;
        return true;
    }

    private boolean isNotPermitted(@NotNull String inputString) {
        if (inputString == null) {
            GitNewBranchNameValidator.$$$reportNull$$$0(4);
        }
        if (inputString.equalsIgnoreCase("head")) {
            this.myErrorText = "Branch name " + inputString + " is not valid";
            return true;
        }
        return false;
    }

    private boolean conflictsWithLocalBranch(@NotNull String inputString) {
        if (inputString == null) {
            GitNewBranchNameValidator.$$$reportNull$$$0(5);
        }
        return this.conflictsWithLocalOrRemote(inputString, true, " already exists");
    }

    private boolean conflictsWithRemoteBranch(@NotNull String inputString) {
        if (inputString == null) {
            GitNewBranchNameValidator.$$$reportNull$$$0(6);
        }
        return this.conflictsWithLocalOrRemote(inputString, false, " clashes with remote branch with the same name");
    }

    private boolean conflictsWithLocalOrRemote(@NotNull String inputString, boolean local, @NotNull String message) {
        if (inputString == null) {
            GitNewBranchNameValidator.$$$reportNull$$$0(7);
        }
        if (message == null) {
            GitNewBranchNameValidator.$$$reportNull$$$0(8);
        }
        int conflictsWithCurrentName = 0;
        for (GitRepository gitRepository : this.myRepositories) {
            if (inputString.equals(gitRepository.getCurrentBranchName())) {
                ++conflictsWithCurrentName;
                continue;
            }
            GitBranchesCollection branchesCollection = gitRepository.getBranches();
            Collection<GitBranch> branches2 = local ? branchesCollection.getLocalBranches() : branchesCollection.getRemoteBranches();
            for (GitBranch branch : branches2) {
                if (!branch.getName().equals(inputString)) continue;
                this.myErrorText = "Branch name " + inputString + message;
                if (this.myRepositories.size() > 1 && !this.allReposHaveBranch(inputString, local)) {
                    this.myErrorText = this.myErrorText + " in repository " + gitRepository.getPresentableUrl();
                }
                return true;
            }
        }
        if (conflictsWithCurrentName == this.myRepositories.size()) {
            this.myErrorText = "You are already on branch " + inputString;
            return true;
        }
        return false;
    }

    private boolean allReposHaveBranch(String inputString, boolean local) {
        for (GitRepository gitRepository : this.myRepositories) {
            GitBranchesCollection branchesCollection = gitRepository.getBranches();
            Collection<GitBranch> branches2 = local ? branchesCollection.getLocalBranches() : branchesCollection.getRemoteBranches();
            if (GitBranchUtil.convertBranchesToNames(branches2).contains(inputString)) continue;
            return false;
        }
        return true;
    }

    public boolean canClose(String inputString) {
        return this.checkInput(inputString);
    }

    public String getErrorText(String inputString) {
        return this.myErrorText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputString";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "git4idea/validators/GitNewBranchNameValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "newInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInput";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBranchConflict";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotPermitted";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "conflictsWithLocalBranch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "conflictsWithRemoteBranch";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "conflictsWithLocalOrRemote";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

