/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.SquashMessageFormatter;
import org.eclipse.jgit.merge.ThreeWayMergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.ImmutableUpdateResult;
import org.jetbrains.settingsRepository.MutableUpdateResult;
import org.jetbrains.settingsRepository.RepositoryManagerKt;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryClient;
import org.jetbrains.settingsRepository.git.GitRepositoryManagerKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;
import org.jetbrains.settingsRepository.git.MergeResultEx;
import org.jetbrains.settingsRepository.git.Pull;
import org.jetbrains.settingsRepository.git.PullKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0016\b\u0002\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u001eJL\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001a2\b\b\u0002\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020'2\b\b\u0002\u0010+\u001a\u00020'2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-J5\u0010.\u001a\u0004\u0018\u00010/2\b\b\u0002\u0010$\u001a\u00020%2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u001aH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00062"}, d2={"Lorg/jetbrains/settingsRepository/git/Pull;", "", "manager", "Lorg/jetbrains/settingsRepository/git/GitRepositoryClient;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "commitMessageFormatter", "Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "(Lorg/jetbrains/settingsRepository/git/GitRepositoryClient;Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;)V", "getCommitMessageFormatter", "()Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "config", "Lorg/eclipse/jgit/lib/StoredConfig;", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "getManager", "()Lorg/jetbrains/settingsRepository/git/GitRepositoryClient;", "remoteConfig", "Lorg/eclipse/jgit/transport/RemoteConfig;", "getRemoteConfig", "()Lorg/eclipse/jgit/transport/RemoteConfig;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "getRepository", "()Lorg/eclipse/jgit/lib/Repository;", "fetch", "Lorg/eclipse/jgit/lib/Ref;", "prevRefUpdateResult", "Lorg/eclipse/jgit/lib/RefUpdate$Result;", "refUpdateProcessor", "Lkotlin/Function1;", "Lorg/eclipse/jgit/transport/TrackingRefUpdate;", "", "merge", "Lorg/jetbrains/settingsRepository/git/MergeResultEx;", "unpeeledRef", "mergeStrategy", "Lorg/eclipse/jgit/merge/MergeStrategy;", "commit", "", "fastForwardMode", "Lorg/eclipse/jgit/api/MergeCommand$FastForwardMode;", "squash", "forceMerge", "commitMessage", "", "pull", "Lorg/jetbrains/settingsRepository/UpdateResult;", "prefetchedRefToMerge", "(Lorg/eclipse/jgit/merge/MergeStrategy;Ljava/lang/String;Lorg/eclipse/jgit/lib/Ref;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.settingsRepository"})
public class Pull {
    @NotNull
    private final Repository repository;
    private final StoredConfig config;
    @NotNull
    private final RemoteConfig remoteConfig;
    @NotNull
    private final GitRepositoryClient manager;
    @Nullable
    private final ProgressIndicator indicator;
    @NotNull
    private final CommitMessageFormatter commitMessageFormatter;

    @NotNull
    public final Repository getRepository() {
        return this.repository;
    }

    @NotNull
    public final RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object pull(@NotNull MergeStrategy mergeStrategy, @Nullable String commitMessage, @Nullable Ref prefetchedRefToMerge, @NotNull Continuation<? super UpdateResult> $completion) {
        block15: {
            if (!($completion instanceof pull.1)) ** GOTO lbl-1000
            var17_5 = $completion;
            if ((var17_5.label & -2147483648) != 0) {
                var17_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    int label;
                    final /* synthetic */ Pull this$0;
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.pull(null, null, null, (Continuation<? super UpdateResult>)this);
                    }
                    {
                        this.this$0 = pull2;
                        super(continuation);
                    }
                };
            }
            $result = $continuation.result;
            var18_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = this.indicator;
                    if (v0 != null) {
                        v0.checkCanceled();
                    }
                    IcsManagerKt.getLOG().debug("Pull");
                    $continuation.L$0 = this;
                    $continuation.L$1 = mergeStrategy;
                    $continuation.L$2 = commitMessage;
                    $continuation.L$3 = prefetchedRefToMerge;
                    $continuation.label = 1;
                    v1 = PullKt.fixAndGetState(this.repository, (Continuation<? super RepositoryState>)$continuation);
                    if (v1 == var18_7) {
                        return var18_7;
                    }
                    ** GOTO lbl32
                }
                case 1: {
                    prefetchedRefToMerge = (Ref)$continuation.L$3;
                    commitMessage = (String)$continuation.L$2;
                    mergeStrategy = (MergeStrategy)$continuation.L$1;
                    this = (Pull)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl32:
                    // 2 sources

                    if (!(state = (RepositoryState)v1).canCheckout()) {
                        IcsManagerKt.getLOG().error("Cannot pull, repository in state " + state.getDescription());
                        return null;
                    }
                    v2 = prefetchedRefToMerge;
                    if (v2 == null) {
                        v2 = Pull.fetch$default(this, null, null, 3, null);
                    }
                    if (v2 == null) {
                        return null;
                    }
                    refToMerge = v2;
                    mergeResult = Pull.merge$default(this, refToMerge, mergeStrategy, false, null, false, false, commitMessage, 60, null);
                    mergeStatus = mergeResult.getStatus();
                    $this$debug$iv = IcsManagerKt.getLOG();
                    e$iv = null;
                    $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        var14_19 = $this$debug$iv;
                        $i$a$-debug-Pull$pull$2 = false;
                        var15_21 = mergeStatus.toString();
                        var14_19.debug(var15_21, (Throwable)e$iv);
                    }
                    if (mergeStatus != MergeResult.MergeStatus.CONFLICTING) break;
                    $continuation.L$0 = this;
                    $continuation.L$1 = mergeStrategy;
                    $continuation.L$2 = commitMessage;
                    $continuation.L$3 = prefetchedRefToMerge;
                    $continuation.L$4 = state;
                    $continuation.L$5 = refToMerge;
                    $continuation.L$6 = mergeResult;
                    $continuation.L$7 = mergeStatus;
                    $continuation.label = 2;
                    v3 = PullKt.resolveConflicts(mergeResult, this.repository, (Continuation<? super MutableUpdateResult>)$continuation);
                    if (v3 == var18_7) {
                        return var18_7;
                    }
                    ** GOTO lbl78
                }
                case 2: {
                    mergeStatus = (MergeResult.MergeStatus)$continuation.L$7;
                    mergeResult = (MergeResultEx)$continuation.L$6;
                    refToMerge = (Ref)$continuation.L$5;
                    state = (RepositoryState)$continuation.L$4;
                    prefetchedRefToMerge = (Ref)$continuation.L$3;
                    commitMessage = (String)$continuation.L$2;
                    mergeStrategy = (MergeStrategy)$continuation.L$1;
                    this = (Pull)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl78:
                    // 2 sources

                    v4 = (UpdateResult)v3;
                    break block15;
                }
            }
            if (!mergeStatus.isSuccessful()) {
                throw (Throwable)new IllegalStateException(mergeResult.toString());
            }
            v4 = mergeResult.getResult();
        }
        return v4;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object pull$default(Pull pull2, MergeStrategy mergeStrategy, String string, Ref ref, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pull");
        }
        if ((n & 1) != 0) {
            ThreeWayMergeStrategy threeWayMergeStrategy = MergeStrategy.RECURSIVE;
            Intrinsics.checkExpressionValueIsNotNull((Object)threeWayMergeStrategy, (String)"MergeStrategy.RECURSIVE");
            mergeStrategy = (MergeStrategy)threeWayMergeStrategy;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            ref = null;
        }
        return pull2.pull(mergeStrategy, string, ref, (Continuation<? super UpdateResult>)continuation);
    }

    @Nullable
    public final Ref fetch(@Nullable RefUpdate.Result prevRefUpdateResult, @Nullable Function1<? super TrackingRefUpdate, Unit> refUpdateProcessor) {
        ProgressIndicator progressIndicator = this.indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        FetchResult fetchResult = GitExKt.fetch(this.repository, this.remoteConfig, this.manager.getCredentialsProvider(), JGitProgressMonitorKt.asProgressMonitor(this.indicator));
        if (fetchResult == null) {
            return null;
        }
        FetchResult fetchResult2 = fetchResult;
        if (IcsManagerKt.getLOG().isDebugEnabled()) {
            GitRepositoryManagerKt.printMessages((OperationResult)fetchResult2);
            for (TrackingRefUpdate refUpdate : fetchResult2.getTrackingRefUpdates()) {
                IcsManagerKt.getLOG().debug(refUpdate.toString());
            }
        }
        ProgressIndicator progressIndicator2 = this.indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.checkCanceled();
        }
        boolean hasChanges = false;
        Iterator iterator = this.remoteConfig.getFetchRefSpecs().iterator();
        while (iterator.hasNext()) {
            RefSpec fetchRefSpec;
            RefSpec refSpec = fetchRefSpec = (RefSpec)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)refSpec, (String)"fetchRefSpec");
            TrackingRefUpdate refUpdate = fetchResult2.getTrackingRefUpdate(refSpec.getDestination());
            if (refUpdate == null) {
                IcsManagerKt.getLOG().debug("No ref update for " + fetchRefSpec);
                continue;
            }
            RefUpdate.Result refUpdateResult = refUpdate.getResult();
            if (refUpdateResult == RefUpdate.Result.LOCK_FAILURE || refUpdateResult == RefUpdate.Result.IO_FAILURE) {
                if (prevRefUpdateResult == refUpdateResult) {
                    throw (Throwable)new IOException("Ref update result " + refUpdateResult.name() + ", we have already tried to fetch again, but no luck");
                }
                IcsManagerKt.getLOG().warn("Ref update result " + refUpdateResult.name() + ", trying again after 500 ms");
                Thread.sleep(500L);
                return Pull.fetch$default(this, refUpdateResult, null, 2, null);
            }
            if (refUpdateResult != RefUpdate.Result.FAST_FORWARD && refUpdateResult != RefUpdate.Result.NEW && refUpdateResult != RefUpdate.Result.FORCED) {
                throw (Throwable)new UnsupportedOperationException("Unsupported ref update result");
            }
            if (!hasChanges) {
                hasChanges = refUpdateResult != RefUpdate.Result.NO_CHANGE;
            }
            Function1<? super TrackingRefUpdate, Unit> function1 = refUpdateProcessor;
            if (function1 == null) continue;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)refUpdate);
        }
        if (!hasChanges) {
            IcsManagerKt.getLOG().debug("No remote changes");
            return null;
        }
        Ref ref = fetchResult2.getAdvertisedRef(GitExKt.getRemoteBranchFullName((Config)this.config));
        if (ref == null) {
            throw (Throwable)new IllegalStateException("Could not get advertised ref");
        }
        return ref;
    }

    public static /* synthetic */ Ref fetch$default(Pull pull2, RefUpdate.Result result, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetch");
        }
        if ((n & 1) != 0) {
            result = null;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        return pull2.fetch(result, (Function1<? super TrackingRefUpdate, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final MergeResultEx merge(@NotNull Ref unpeeledRef, @NotNull MergeStrategy mergeStrategy, boolean commit2, @NotNull MergeCommand.FastForwardMode fastForwardMode, boolean squash, boolean forceMerge, @Nullable String commitMessage) {
        Ref ref;
        Intrinsics.checkParameterIsNotNull((Object)unpeeledRef, (String)"unpeeledRef");
        Intrinsics.checkParameterIsNotNull((Object)mergeStrategy, (String)"mergeStrategy");
        Intrinsics.checkParameterIsNotNull((Object)fastForwardMode, (String)"fastForwardMode");
        ProgressIndicator progressIndicator = this.indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        Ref ref2 = this.repository.findRef("HEAD");
        if (ref2 == null) {
            throw (Throwable)new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
        }
        Ref head = ref2;
        Ref ref3 = ref = this.repository.getRefDatabase().peel(unpeeledRef);
        Intrinsics.checkExpressionValueIsNotNull((Object)ref3, (String)"ref");
        ObjectId objectId = ref3.getPeeledObjectId();
        if (objectId == null) {
            objectId = ref.getObjectId();
        }
        ObjectId objectId2 = objectId;
        DirCacheCheckout dirCacheCheckout = null;
        try (RevWalk revWalk = new RevWalk(this.repository);){
            ImmutableUpdateResult immutableUpdateResult;
            RevCommit srcCommit = revWalk.lookupCommit((AnyObjectId)objectId2);
            ObjectId headId = head.getObjectId();
            if (headId == null) {
                revWalk.parseHeaders((RevObject)srcCommit);
                DirCache dirCache = this.repository.lockDirCache();
                RevCommit revCommit = srcCommit;
                Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"srcCommit");
                dirCacheCheckout = new DirCacheCheckout(this.repository, dirCache, (ObjectId)revCommit.getTree());
                dirCacheCheckout.setFailOnConflict(false);
                dirCacheCheckout.checkout();
                Ref ref4 = head.getTarget();
                Intrinsics.checkExpressionValueIsNotNull((Object)ref4, (String)"head.target");
                RefUpdate refUpdate = this.repository.updateRef(ref4.getName());
                refUpdate.setNewObjectId((AnyObjectId)objectId2);
                refUpdate.setExpectedOldObjectId(null);
                refUpdate.setRefLogMessage("initial pull", false);
                if (refUpdate.update() != RefUpdate.Result.NEW) {
                    throw (Throwable)new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                ObjectId[] objectIdArray = new ObjectId[]{null, (ObjectId)srcCommit};
                Collection collection = dirCacheCheckout.getUpdated().keySet();
                List list = dirCacheCheckout.getRemoved();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dirCacheCheckout.removed");
                MergeResultEx mergeResultEx = new MergeResultEx(MergeResult.MergeStatus.FAST_FORWARD, objectIdArray, new ImmutableUpdateResult(collection, list), null, 8, null);
                return mergeResultEx;
            }
            StringBuilder refLogMessage = new StringBuilder("merge ");
            refLogMessage.append(ref.getName());
            RevCommit headCommit = revWalk.lookupCommit((AnyObjectId)headId);
            if (!forceMerge && revWalk.isMergedInto(srcCommit, headCommit)) {
                MergeResultEx mergeResultEx = new MergeResultEx(MergeResult.MergeStatus.ALREADY_UP_TO_DATE, new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit}, RepositoryManagerKt.getEMPTY_UPDATE_RESULT(), null, 8, null);
                return mergeResultEx;
            }
            if (!forceMerge && fastForwardMode != MergeCommand.FastForwardMode.NO_FF && revWalk.isMergedInto(headCommit, srcCommit)) {
                Object squashedCommits;
                refLogMessage.append(": ").append(MergeResult.MergeStatus.FAST_FORWARD);
                RevCommit revCommit = headCommit;
                Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"headCommit");
                ObjectId objectId3 = (ObjectId)revCommit.getTree();
                DirCache dirCache = this.repository.lockDirCache();
                RevCommit revCommit2 = srcCommit;
                Intrinsics.checkExpressionValueIsNotNull((Object)revCommit2, (String)"srcCommit");
                dirCacheCheckout = new DirCacheCheckout(this.repository, objectId3, dirCache, (ObjectId)revCommit2.getTree());
                dirCacheCheckout.setFailOnConflict(false);
                dirCacheCheckout.checkout();
                MergeResult.MergeStatus mergeStatus = null;
                if (squash) {
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD_SQUASHED;
                    squashedCommits = RevWalkUtils.find((RevWalk)revWalk, (RevCommit)srcCommit, (RevCommit)headCommit);
                    this.repository.writeSquashCommitMsg(new SquashMessageFormatter().format((List)squashedCommits, head));
                } else {
                    PullKt.access$updateHead(refLogMessage, (ObjectId)srcCommit, headId, this.repository);
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD;
                }
                ObjectId[] objectIdArray = new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit};
                Collection collection = dirCacheCheckout.getUpdated().keySet();
                List list = dirCacheCheckout.getRemoved();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dirCacheCheckout.removed");
                squashedCommits = new MergeResultEx(mergeStatus, objectIdArray, new ImmutableUpdateResult(collection, list), null, 8, null);
                return squashedCommits;
            }
            if (fastForwardMode == MergeCommand.FastForwardMode.FF_ONLY) {
                MergeResultEx mergeStatus = new MergeResultEx(MergeResult.MergeStatus.ABORTED, new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit}, RepositoryManagerKt.getEMPTY_UPDATE_RESULT(), null, 8, null);
                return mergeStatus;
            }
            String mergeMessage = null;
            if (squash) {
                mergeMessage = "";
                this.repository.writeSquashCommitMsg(new SquashMessageFormatter().format(RevWalkUtils.find((RevWalk)revWalk, (RevCommit)srcCommit, (RevCommit)headCommit), head));
            } else {
                mergeMessage = this.commitMessageFormatter.mergeMessage(CollectionsKt.listOf((Object)ref), head);
                this.repository.writeMergeCommitMsg(mergeMessage);
                this.repository.writeMergeHeads(CollectionsKt.listOf((Object)ref.getObjectId()));
            }
            Merger merger = mergeStrategy.newMerger(this.repository);
            boolean noProblems = false;
            Map lowLevelResults = null;
            Map failingPaths = null;
            List unmergedPaths = null;
            if (merger instanceof ResolveMerger) {
                ((ResolveMerger)merger).setCommitNames(new String[]{"BASE", "HEAD", ref.getName()});
                ((ResolveMerger)merger).setWorkingTreeIterator((WorkingTreeIterator)new FileTreeIterator(this.repository));
                noProblems = merger.merge(new AnyObjectId[]{(AnyObjectId)headCommit, (AnyObjectId)srcCommit});
                lowLevelResults = ((ResolveMerger)merger).getMergeResults();
                failingPaths = ((ResolveMerger)merger).getFailingPaths();
                unmergedPaths = ((ResolveMerger)merger).getUnmergedPaths();
            } else {
                noProblems = merger.merge(new AnyObjectId[]{(AnyObjectId)headCommit, (AnyObjectId)srcCommit});
            }
            refLogMessage.append(": Merge made by ");
            refLogMessage.append(revWalk.isMergedInto(headCommit, srcCommit) ? "recursive" : mergeStrategy.getName());
            refLogMessage.append('.');
            if (merger instanceof ResolveMerger) {
                Collection collection = ((ResolveMerger)merger).getToBeCheckedOut().keySet();
                List list = ((ResolveMerger)merger).getToBeDeleted();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"merger.toBeDeleted");
                immutableUpdateResult = new ImmutableUpdateResult(collection, list);
            } else {
                immutableUpdateResult = null;
            }
            ImmutableUpdateResult result = immutableUpdateResult;
            if (noProblems) {
                if (!(merger instanceof ResolveMerger)) {
                    RevCommit revCommit = headCommit;
                    Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"headCommit");
                    ObjectId objectId4 = (ObjectId)revCommit.getTree();
                    DirCache dirCache = this.repository.lockDirCache();
                    Merger merger2 = merger;
                    Intrinsics.checkExpressionValueIsNotNull((Object)merger2, (String)"merger");
                    dirCacheCheckout = new DirCacheCheckout(this.repository, objectId4, dirCache, merger2.getResultTreeId());
                    dirCacheCheckout.setFailOnConflict(false);
                    dirCacheCheckout.checkout();
                    Collection collection = dirCacheCheckout.getUpdated().keySet();
                    List list = dirCacheCheckout.getRemoved();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dirCacheCheckout.removed");
                    result = new ImmutableUpdateResult(collection, list);
                }
                MergeResult.MergeStatus mergeStatus = null;
                if (!commit2 && squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED_NOT_COMMITTED;
                }
                if (!commit2 && !squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_NOT_COMMITTED;
                }
                if (commit2 && !squash) {
                    GitExKt.commit$default(this.repository, commitMessage, refLogMessage.toString(), null, null, 12, null).getId();
                    mergeStatus = MergeResult.MergeStatus.MERGED;
                }
                if (commit2 && squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED;
                }
                MergeResult.MergeStatus mergeStatus2 = mergeStatus;
                if (mergeStatus2 == null) {
                    Intrinsics.throwNpe();
                }
                ObjectId[] objectIdArray = new ObjectId[2];
                RevCommit revCommit = headCommit;
                Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"headCommit");
                objectIdArray[0] = revCommit.getId();
                RevCommit revCommit3 = srcCommit;
                Intrinsics.checkExpressionValueIsNotNull((Object)revCommit3, (String)"srcCommit");
                objectIdArray[1] = revCommit3.getId();
                ImmutableUpdateResult immutableUpdateResult2 = result;
                if (immutableUpdateResult2 == null) {
                    Intrinsics.throwNpe();
                }
                MergeResultEx mergeResultEx = new MergeResultEx(mergeStatus2, objectIdArray, immutableUpdateResult2, null, 8, null);
                return mergeResultEx;
            }
            if (failingPaths == null) {
                this.repository.writeMergeCommitMsg(new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths));
                ObjectId[] objectIdArray = new ObjectId[2];
                RevCommit revCommit = headCommit;
                Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"headCommit");
                objectIdArray[0] = revCommit.getId();
                RevCommit revCommit4 = srcCommit;
                Intrinsics.checkExpressionValueIsNotNull((Object)revCommit4, (String)"srcCommit");
                objectIdArray[1] = revCommit4.getId();
                ImmutableUpdateResult immutableUpdateResult3 = result;
                if (immutableUpdateResult3 == null) {
                    Intrinsics.throwNpe();
                }
                MergeResultEx mergeResultEx = new MergeResultEx(MergeResult.MergeStatus.CONFLICTING, objectIdArray, immutableUpdateResult3, lowLevelResults);
                return mergeResultEx;
            }
            this.repository.writeMergeCommitMsg(null);
            this.repository.writeMergeHeads(null);
            ObjectId[] objectIdArray = new ObjectId[2];
            RevCommit revCommit = headCommit;
            Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"headCommit");
            objectIdArray[0] = revCommit.getId();
            RevCommit revCommit5 = srcCommit;
            Intrinsics.checkExpressionValueIsNotNull((Object)revCommit5, (String)"srcCommit");
            objectIdArray[1] = revCommit5.getId();
            ImmutableUpdateResult immutableUpdateResult4 = result;
            if (immutableUpdateResult4 == null) {
                Intrinsics.throwNpe();
            }
            MergeResultEx mergeResultEx = new MergeResultEx(MergeResult.MergeStatus.FAILED, objectIdArray, immutableUpdateResult4, lowLevelResults);
            return mergeResultEx;
        }
    }

    public static /* synthetic */ MergeResultEx merge$default(Pull pull2, Ref ref, MergeStrategy mergeStrategy, boolean bl, MergeCommand.FastForwardMode fastForwardMode, boolean bl2, boolean bl3, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: merge");
        }
        if ((n & 2) != 0) {
            ThreeWayMergeStrategy threeWayMergeStrategy = MergeStrategy.RECURSIVE;
            Intrinsics.checkExpressionValueIsNotNull((Object)threeWayMergeStrategy, (String)"MergeStrategy.RECURSIVE");
            mergeStrategy = (MergeStrategy)threeWayMergeStrategy;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            fastForwardMode = MergeCommand.FastForwardMode.FF;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            string = null;
        }
        return pull2.merge(ref, mergeStrategy, bl, fastForwardMode, bl2, bl3, string);
    }

    @NotNull
    public final GitRepositoryClient getManager() {
        return this.manager;
    }

    @Nullable
    public final ProgressIndicator getIndicator() {
        return this.indicator;
    }

    @NotNull
    public final CommitMessageFormatter getCommitMessageFormatter() {
        return this.commitMessageFormatter;
    }

    public Pull(@NotNull GitRepositoryClient manager, @Nullable ProgressIndicator indicator, @NotNull CommitMessageFormatter commitMessageFormatter) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)commitMessageFormatter, (String)"commitMessageFormatter");
        this.manager = manager;
        this.indicator = indicator;
        this.commitMessageFormatter = commitMessageFormatter;
        this.repository = this.manager.getRepository();
        StoredConfig storedConfig = this.repository.getConfig();
        if (storedConfig == null) {
            Intrinsics.throwNpe();
        }
        this.config = storedConfig;
        this.remoteConfig = new RemoteConfig((Config)this.config, "origin");
    }

    public /* synthetic */ Pull(GitRepositoryClient gitRepositoryClient, ProgressIndicator progressIndicator, CommitMessageFormatter commitMessageFormatter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            commitMessageFormatter = new IdeaCommitMessageFormatter();
        }
        this(gitRepositoryClient, progressIndicator, commitMessageFormatter);
    }
}

