/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.io.ByteSequenceDataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentMapBasedForwardIndex
implements ForwardIndex {
    private static final Logger LOG = Logger.getInstance(PersistentMapBasedForwardIndex.class);
    @NotNull
    private volatile PersistentHashMap<Integer, ByteArraySequence> myPersistentMap;
    @NotNull
    private final File myMapFile;
    private final boolean myUseChunks;

    public PersistentMapBasedForwardIndex(@NotNull File mapFile) throws IOException {
        if (mapFile == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(0);
        }
        this(mapFile, true);
    }

    public PersistentMapBasedForwardIndex(@NotNull File mapFile, boolean useChunks) throws IOException {
        if (mapFile == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(1);
        }
        this.myPersistentMap = this.createMap(mapFile);
        this.myMapFile = mapFile;
        this.myUseChunks = useChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected PersistentHashMap<Integer, ByteArraySequence> createMap(File file) throws IOException {
        Boolean oldHasNoChunksValue = PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.get();
        PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(!this.myUseChunks);
        PersistentHashMap<Integer, ByteArraySequence> persistentHashMap = new PersistentHashMap<Integer, ByteArraySequence>(file, EnumeratorIntegerDescriptor.INSTANCE, ByteSequenceDataExternalizer.INSTANCE);
        PersistentHashMap<Integer, ByteArraySequence> persistentHashMap2 = persistentHashMap;
        if (persistentHashMap2 == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(2);
        }
        return persistentHashMap2;
        finally {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(oldHasNoChunksValue);
        }
    }

    @Override
    @Nullable
    public ByteArraySequence get(@NotNull Integer key) throws IOException {
        if (key == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(3);
        }
        return this.myPersistentMap.get(key);
    }

    @Override
    public void put(@NotNull Integer key, @Nullable ByteArraySequence value) throws IOException {
        if (key == null) {
            PersistentMapBasedForwardIndex.$$$reportNull$$$0(4);
        }
        if (value == null) {
            this.myPersistentMap.remove(key);
        } else {
            this.myPersistentMap.put(key, value);
        }
    }

    @Override
    public void force() {
        this.myPersistentMap.force();
    }

    @Override
    public void clear() throws IOException {
        File baseFile = this.myPersistentMap.getBaseFile();
        try {
            this.myPersistentMap.close();
        }
        catch (Exception e) {
            LOG.error(e);
        }
        PersistentHashMap.deleteFilesStartingWith(baseFile);
        this.myPersistentMap = this.createMap(this.myMapFile);
    }

    @Override
    public void close() throws IOException {
        this.myPersistentMap.close();
    }

    public boolean isBusyReading() {
        return this.myPersistentMap.isBusyReading();
    }

    public boolean containsMapping(int key) throws IOException {
        return this.myPersistentMap.containsMapping(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/forward/PersistentMapBasedForwardIndex";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/forward/PersistentMapBasedForwardIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

