/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.containers;

import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.containers.IdBitSet;
import com.intellij.util.indexing.containers.IntIdsIterator;
import com.intellij.util.indexing.containers.RandomAccessIntContainer;
import com.intellij.util.indexing.containers.SortedFileIdSetIterator;
import com.intellij.util.indexing.containers.SortedIdSet;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ChangeBufferingList
implements Cloneable {
    static final int MAX_FILES = 20000;
    private volatile int[] changes;
    private short length;
    private boolean hasRemovals;
    private volatile boolean mayHaveDupes;
    private volatile RandomAccessIntContainer randomAccessContainer;

    public ChangeBufferingList() {
        this(3);
    }

    public ChangeBufferingList(int length) {
        if (length > 20000) {
            this.randomAccessContainer = new IdBitSet(length);
        } else {
            this.changes = new int[length];
        }
    }

    @NotNull
    static int[] calcMinMax(int[] set, int length) {
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            max = Math.max(max, set[i]);
            min = Math.min(min, set[i]);
        }
        int[] nArray = new int[]{min, max};
        if (nArray == null) {
            ChangeBufferingList.$$$reportNull$$$0(0);
        }
        return nArray;
    }

    public void add(int value) {
        this.ensureCapacity(1);
        RandomAccessIntContainer intContainer = this.randomAccessContainer;
        if (intContainer == null) {
            this.addChange(value);
        } else {
            intContainer.add(value);
        }
    }

    private void addChange(int value) {
        if (value < 0) {
            if (!this.hasRemovals) {
                this.hasRemovals = true;
            }
        } else if (!this.mayHaveDupes && this.length > 0 && this.changes[this.length - 1] >= value) {
            this.mayHaveDupes = true;
        }
        short s = this.length;
        this.length = (short)(s + 1);
        this.changes[s] = value;
    }

    public void remove(int value) {
        this.ensureCapacity(1);
        RandomAccessIntContainer intContainer = this.randomAccessContainer;
        if (intContainer == null) {
            this.addChange(-value);
        } else {
            boolean removed = intContainer.remove(value);
            if (removed) {
                intContainer.compact();
            }
        }
    }

    public Object clone() {
        try {
            ChangeBufferingList clone = (ChangeBufferingList)super.clone();
            if (this.changes != null) {
                clone.changes = (int[])this.changes.clone();
            }
            if (this.randomAccessContainer != null) {
                clone.randomAccessContainer = (RandomAccessIntContainer)this.randomAccessContainer.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessIntContainer getRandomAccessContainer() {
        int[] currentChanges = this.changes;
        if (currentChanges == null) {
            return this.randomAccessContainer;
        }
        int[] nArray = currentChanges;
        synchronized (currentChanges) {
            RandomAccessIntContainer idSet;
            currentChanges = this.changes;
            if (currentChanges == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.randomAccessContainer;
            }
            boolean copyChanges = true;
            if (this.randomAccessContainer == null) {
                short someElementsNumberEstimation = this.length;
                if (someElementsNumberEstimation < 20000) {
                    if (!this.hasRemovals) {
                        if (this.mayHaveDupes) {
                            this.removingDupesAndSort();
                        }
                        idSet = new SortedIdSet(currentChanges, this.length);
                        copyChanges = false;
                    } else {
                        idSet = new SortedIdSet(Math.max(someElementsNumberEstimation, 3));
                    }
                } else if (!this.hasRemovals) {
                    idSet = new IdBitSet(this.changes, this.length, 0);
                    copyChanges = false;
                } else {
                    idSet = new IdBitSet(ChangeBufferingList.calcMinMax(this.changes, this.length), 0);
                }
            } else {
                idSet = this.randomAccessContainer;
            }
            assert (idSet != null);
            if (copyChanges) {
                int len = this.length;
                for (int i = 0; i < len; ++i) {
                    int id = currentChanges[i];
                    if (id > 0) {
                        idSet.add(id);
                        continue;
                    }
                    idSet.remove(-id);
                }
            }
            this.length = 0;
            this.hasRemovals = false;
            this.mayHaveDupes = false;
            this.randomAccessContainer = idSet;
            this.changes = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.randomAccessContainer;
        }
    }

    private void removingDupesAndSort() {
        int[] currentChanges = this.changes;
        int intLength = this.length;
        if (intLength < 250) {
            Arrays.sort(currentChanges, 0, intLength);
            boolean hasDupes = false;
            int max = intLength - 1;
            for (int i = 0; i < max; ++i) {
                if (currentChanges[i] != currentChanges[i + 1]) continue;
                hasDupes = true;
                break;
            }
            if (hasDupes) {
                int ptr = 0;
                for (int i = 1; i < intLength; ++i) {
                    if (currentChanges[i] == currentChanges[ptr]) continue;
                    currentChanges[++ptr] = currentChanges[i];
                }
                this.length = (short)(ptr + 1);
            }
        } else {
            IntIdsIterator sorted = SortedFileIdSetIterator.getTransientIterator(new ChangesIterator(currentChanges, this.length, false));
            int lastIndex = 0;
            while (sorted.hasNext()) {
                currentChanges[lastIndex++] = sorted.next();
            }
            this.length = (short)lastIndex;
        }
        this.mayHaveDupes = false;
    }

    public void ensureCapacity(int diff) {
        RandomAccessIntContainer intContainer = this.randomAccessContainer;
        if (this.length == 20000) {
            intContainer = this.getRandomAccessContainer();
        }
        if (intContainer != null) {
            this.randomAccessContainer = intContainer.ensureContainerCapacity(diff);
            return;
        }
        if (this.changes == null) {
            this.changes = new int[Math.max(3, diff)];
        } else if (this.length + diff > this.changes.length) {
            int[] newChanges = new int[ChangeBufferingList.calcNextArraySize(this.changes.length, this.length + diff)];
            System.arraycopy(this.changes, 0, newChanges, 0, this.length);
            this.changes = newChanges;
        }
    }

    static int calcNextArraySize(int currentSize, int wantedSize) {
        return Math.min(Math.max(currentSize < 1024 ? currentSize << 1 : currentSize + currentSize / 5, wantedSize), 20000);
    }

    public boolean isEmpty() {
        RandomAccessIntContainer intContainer;
        if (this.randomAccessContainer == null) {
            if (this.changes == null) {
                return true;
            }
            if (!this.hasRemovals) {
                return this.length == 0;
            }
        }
        return (intContainer = this.getRandomAccessContainer()).size() == 0;
    }

    public ValueContainer.IntPredicate intPredicate() {
        return this.getRandomAccessContainer().intPredicate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IntIdsIterator intIterator() {
        int[] currentChanges;
        RandomAccessIntContainer intContainer = this.randomAccessContainer;
        if (intContainer != null || this.hasRemovals || (currentChanges = this.changes) == null) return this.getRandomAccessContainer().intIterator();
        if (!this.mayHaveDupes) return new ChangesIterator(currentChanges, this.length, true);
        int[] nArray = currentChanges;
        synchronized (currentChanges) {
            if (!this.mayHaveDupes) return new ChangesIterator(currentChanges, this.length, true);
            this.removingDupesAndSort();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new ChangesIterator(currentChanges, this.length, true);
        }
    }

    public IntIdsIterator sortedIntIterator() {
        IntIdsIterator intIterator = this.intIterator();
        if (!intIterator.hasAscendingOrder()) {
            intIterator = SortedFileIdSetIterator.getTransientIterator(intIterator);
        }
        return intIterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/containers/ChangeBufferingList", "calcMinMax"));
    }

    private static class ChangesIterator
    implements IntIdsIterator {
        private int cursor;
        private final int length;
        private final int[] changes;
        private final boolean sorted;

        ChangesIterator(int[] _changes, int _length, boolean _sorted) {
            this.changes = _changes;
            this.length = _length;
            this.sorted = _sorted;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.length;
        }

        @Override
        public int next() {
            int current = this.cursor++;
            return this.changes[current];
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public boolean hasAscendingOrder() {
            return this.sorted;
        }

        @Override
        public IntIdsIterator createCopyInInitialState() {
            return new ChangesIterator(this.changes, this.length, this.sorted);
        }
    }
}

