/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.jetbrains.python.documentation.docstrings.DocStringBuilder;
import com.jetbrains.python.documentation.docstrings.DocStringUpdater;
import com.jetbrains.python.documentation.docstrings.TagBasedDocString;
import com.jetbrains.python.documentation.docstrings.TagBasedDocStringBuilder;
import com.jetbrains.python.toolbox.Substring;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagBasedDocStringUpdater
extends DocStringUpdater<TagBasedDocString> {
    private final String myTagPrefix;

    public TagBasedDocStringUpdater(@NotNull TagBasedDocString docString, @NotNull String tagPrefix, @NotNull String minContentIndent) {
        if (docString == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(0);
        }
        if (tagPrefix == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(1);
        }
        if (minContentIndent == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(2);
        }
        super(docString, minContentIndent);
        this.myTagPrefix = tagPrefix;
    }

    @NotNull
    private TagBasedDocStringBuilder createBuilder() {
        TagBasedDocStringBuilder tagBasedDocStringBuilder = new TagBasedDocStringBuilder(this.myTagPrefix);
        if (tagBasedDocStringBuilder == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(3);
        }
        return tagBasedDocStringBuilder;
    }

    @Override
    public final void addParameter(@NotNull String name, @Nullable String type) {
        if (name == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(4);
        }
        if (type != null) {
            this.insertTagLine(this.createBuilder().addParameterType(name, type));
        } else {
            this.insertTagLine(this.createBuilder().addParameterDescription(name, ""));
        }
    }

    @Override
    public final void addReturnValue(@Nullable String type) {
        if (type != null) {
            this.insertTagLine(this.createBuilder().addReturnValueType(type));
        } else {
            this.insertTagLine(this.createBuilder().addReturnValueDescription(""));
        }
    }

    @Override
    public void removeParameter(@NotNull String name) {
        if (name == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(5);
        }
        List<Substring> nameSubs = ((TagBasedDocString)this.myOriginalDocString).getParameterSubstrings();
        for (Substring sub : nameSubs) {
            if (!sub.toString().equals(name)) continue;
            int startLine = sub.getStartLine();
            int nextAfterBlock = ((TagBasedDocString)this.myOriginalDocString).consumeIndentedBlock(startLine + 1, this.getLineIndentSize(startLine));
            this.removeLinesAndSpacesAfter(startLine, nextAfterBlock);
        }
    }

    private void insertTagLine(@NotNull DocStringBuilder lineBuilder) {
        int firstLineWithTag;
        if (lineBuilder == null) {
            TagBasedDocStringUpdater.$$$reportNull$$$0(6);
        }
        if ((firstLineWithTag = this.findFirstLineWithTag()) >= 0) {
            String indent = this.getLineIndent(firstLineWithTag);
            this.insertBeforeLine(firstLineWithTag, lineBuilder.buildContent(indent, true));
            return;
        }
        int lastNonEmptyLine = this.findLastNonEmptyLine();
        String indent = this.getLineIndent(lastNonEmptyLine);
        this.insertAfterLine(lastNonEmptyLine, lineBuilder.buildContent(indent, true));
    }

    private int findFirstLineWithTag() {
        for (int i = 0; i < ((TagBasedDocString)this.myOriginalDocString).getLineCount(); ++i) {
            Substring line2 = ((TagBasedDocString)this.myOriginalDocString).getLine(i);
            if (!line2.trimLeft().startsWith(this.myTagPrefix)) continue;
            return i;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagPrefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minContentIndent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/TagBasedDocStringUpdater";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/TagBasedDocStringUpdater";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeParameter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertTagLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

