/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.google.common.primitives.Chars;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultilinePopupBuilder {
    static final char[] SEPARATORS = new char[]{'|', '\n'};
    private static final String COMPLETION_ADVERTISEMENT = "Select one or more values separated with | or new lines";
    @NotNull
    private final EditorTextField myTextField;

    MultilinePopupBuilder(@NotNull Project project, @NotNull Collection<String> values, @NotNull String initialValue, @Nullable CompletionPrefixProvider completionPrefixProvider) {
        if (project == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(0);
        }
        if (values == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(1);
        }
        if (initialValue == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(2);
        }
        this.myTextField = MultilinePopupBuilder.createTextField(project, values, completionPrefixProvider, initialValue);
    }

    @NotNull
    private static EditorTextField createTextField(@NotNull Project project, Collection<String> values, @Nullable CompletionPrefixProvider completionPrefixProvider, @NotNull String initialValue) {
        if (project == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(3);
        }
        if (initialValue == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(4);
        }
        TextFieldWithCompletion textField = new TextFieldWithCompletion(project, (TextCompletionProvider)new MyCompletionProvider(values, completionPrefixProvider), initialValue, false, true, false){

            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                SoftWrapsEditorCustomization.ENABLED.customize(editor);
                return editor;
            }
        };
        textField.setBorder((Border)new CompoundBorder(JBUI.Borders.empty((int)2), textField.getBorder()));
        TextFieldWithCompletion textFieldWithCompletion = textField;
        if (textFieldWithCompletion == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(5);
        }
        return textFieldWithCompletion;
    }

    @NotNull
    JBPopup createPopup() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myTextField, "Center");
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)this.myTextField).setCancelOnClickOutside(true).setAdText("Select one or more values separated with | or new lines, use " + KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.CTRL_ENTER.getShortcuts()) + " to finish").setRequestFocus(true).setResizable(true).setMayBeParent(true);
        final JBPopup popup = builder.createPopup();
        popup.setMinimumSize((Dimension)new JBDimension(200, 90));
        DumbAwareAction okAction = new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.unregisterCustomShortcutSet(popup.getContent());
                popup.closeOk(e.getInputEvent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$2", "actionPerformed"));
            }
        };
        okAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, popup.getContent());
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(6);
        }
        return jBPopup;
    }

    @NotNull
    List<String> getSelectedValues() {
        List list = ContainerUtil.mapNotNull((Iterable)StringUtil.tokenize((String)this.myTextField.getText(), (String)new String(SEPARATORS)), value -> {
            String trimmed = value.trim();
            return trimmed.isEmpty() ? null : trimmed;
        });
        if (list == null) {
            MultilinePopupBuilder.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialValue";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTextField";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCompletionProvider
    extends ValuesCompletionProvider.ValuesCompletionProviderDumbAware<String> {
        @Nullable
        private final CompletionPrefixProvider myCompletionPrefixProvider;

        MyCompletionProvider(@NotNull Collection<String> values, @Nullable CompletionPrefixProvider completionPrefixProvider) {
            if (values == null) {
                MyCompletionProvider.$$$reportNull$$$0(0);
            }
            super((TextCompletionValueDescriptor)new DefaultTextCompletionValueDescriptor.StringValueDescriptor(), Chars.asList((char[])SEPARATORS), values, false);
            this.myCompletionPrefixProvider = completionPrefixProvider;
        }

        @Nullable
        public String getPrefix(@NotNull String text, int offset) {
            if (text == null) {
                MyCompletionProvider.$$$reportNull$$$0(1);
            }
            if (this.myCompletionPrefixProvider != null) {
                return this.myCompletionPrefixProvider.getPrefix(text, offset);
            }
            return super.getPrefix(text, offset);
        }

        @Nullable
        public String getAdvertisement() {
            return MultilinePopupBuilder.COMPLETION_ADVERTISEMENT;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPrefix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface CompletionPrefixProvider {
        public String getPrefix(@NotNull String var1, int var2);
    }
}

