/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogContentUtil {
    private static final Logger LOG = Logger.getInstance(VcsLogContentUtil.class);

    @Nullable
    private static AbstractVcsLogUi getLogUi(@NotNull JComponent c) {
        if (c == null) {
            VcsLogContentUtil.$$$reportNull$$$0(0);
        }
        VcsLogPanel vcsLogPanel = null;
        if (c instanceof VcsLogPanel) {
            vcsLogPanel = (VcsLogPanel)((Object)c);
        } else if (c instanceof JPanel) {
            vcsLogPanel = (VcsLogPanel)((Object)ContainerUtil.findInstance((Object[])c.getComponents(), VcsLogPanel.class));
        }
        if (vcsLogPanel != null) {
            return vcsLogPanel.getUi();
        }
        return null;
    }

    public static <U extends AbstractVcsLogUi> boolean findAndSelectContent(@NotNull Project project, @NotNull Class<U> clazz, @NotNull Condition<? super U> condition) {
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(1);
        }
        if (clazz == null) {
            VcsLogContentUtil.$$$reportNull$$$0(2);
        }
        if (condition == null) {
            VcsLogContentUtil.$$$reportNull$$$0(3);
        }
        return VcsLogContentUtil.findAndSelect(project, clazz, condition) != null;
    }

    @Nullable
    public static <U extends AbstractVcsLogUi> U findAndSelect(@NotNull Project project, @NotNull Class<U> clazz, @NotNull Condition<? super U> condition) {
        ToolWindow toolWindow;
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            VcsLogContentUtil.$$$reportNull$$$0(5);
        }
        if (condition == null) {
            VcsLogContentUtil.$$$reportNull$$$0(6);
        }
        if ((toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS)) == null) {
            return null;
        }
        ContentManager manager = toolWindow.getContentManager();
        JComponent component = ContentUtilEx.findContentComponent((ContentManager)manager, c -> {
            AbstractVcsLogUi ui2 = VcsLogContentUtil.getLogUi(c);
            if (ui2 != null) {
                return clazz.isInstance(ui2) && condition.value((Object)ui2);
            }
            return false;
        });
        if (component == null) {
            return null;
        }
        if (!toolWindow.isVisible()) {
            toolWindow.activate(null);
        }
        if (!ContentUtilEx.selectContent((ContentManager)manager, (JComponent)component, (boolean)true)) {
            return null;
        }
        return (U)VcsLogContentUtil.getLogUi(component);
    }

    public static boolean selectLogUi(@NotNull Project project, @NotNull VcsLogUi ui2) {
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(7);
        }
        if (ui2 == null) {
            VcsLogContentUtil.$$$reportNull$$$0(8);
        }
        return VcsLogContentUtil.findAndSelectContent(project, AbstractVcsLogUi.class, u -> u.equals(ui2));
    }

    @Nullable
    public static String getId(@NotNull Content content) {
        AbstractVcsLogUi ui2;
        if (content == null) {
            VcsLogContentUtil.$$$reportNull$$$0(9);
        }
        if ((ui2 = VcsLogContentUtil.getLogUi(content.getComponent())) == null) {
            return null;
        }
        return ui2.getId();
    }

    @NotNull
    public static String generateTabId(@NotNull Project project) {
        ContentManager contentManager;
        TabbedContent tabbedContent;
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(10);
        }
        Set existingIds = (tabbedContent = ContentUtilEx.findTabbedContent((ContentManager)(contentManager = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS).getContentManager()), (String)"Log")) != null ? ContainerUtil.map2SetNotNull((Collection)tabbedContent.getTabs(), pair -> {
            AbstractVcsLogUi ui2 = VcsLogContentUtil.getLogUi((JComponent)pair.second);
            if (ui2 == null) {
                return null;
            }
            return ui2.getId();
        }) : ContainerUtil.map2SetNotNull(Arrays.asList(contentManager.getContents()), content -> {
            if (!"Log".equals(content.getUserData(Content.TAB_GROUP_NAME_KEY))) {
                return null;
            }
            return VcsLogContentUtil.getId(content);
        });
        int i = 1;
        while (true) {
            String idString;
            if (!existingIds.contains(idString = Integer.toString(i))) {
                String string = idString;
                if (string == null) {
                    VcsLogContentUtil.$$$reportNull$$$0(11);
                }
                return string;
            }
            ++i;
        }
    }

    public static <U extends AbstractVcsLogUi> U openLogTab(@NotNull Project project, @NotNull VcsLogManager logManager, @NotNull String tabGroupName, @NotNull String shortName, @NotNull VcsLogManager.VcsLogUiFactory<U> factory, boolean focus) {
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(12);
        }
        if (logManager == null) {
            VcsLogContentUtil.$$$reportNull$$$0(13);
        }
        if (tabGroupName == null) {
            VcsLogContentUtil.$$$reportNull$$$0(14);
        }
        if (shortName == null) {
            VcsLogContentUtil.$$$reportNull$$$0(15);
        }
        if (factory == null) {
            VcsLogContentUtil.$$$reportNull$$$0(16);
        }
        U logUi = logManager.createLogUi(factory, true);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS);
        ContentUtilEx.addTabbedContent((ContentManager)toolWindow.getContentManager(), (JComponent)((Object)new VcsLogPanel(logManager, (AbstractVcsLogUi)logUi)), (String)tabGroupName, (String)shortName, (boolean)focus, logUi);
        if (focus) {
            toolWindow.activate(null);
        }
        logManager.scheduleInitialization();
        return logUi;
    }

    public static boolean closeLogTab(@NotNull ContentManager manager, @NotNull String tabId) {
        if (manager == null) {
            VcsLogContentUtil.$$$reportNull$$$0(17);
        }
        if (tabId == null) {
            VcsLogContentUtil.$$$reportNull$$$0(18);
        }
        return ContentUtilEx.closeContentTab((ContentManager)manager, c -> {
            AbstractVcsLogUi ui2 = VcsLogContentUtil.getLogUi(c);
            if (ui2 != null) {
                return ui2.getId().equals(tabId);
            }
            return false;
        });
    }

    public static void openMainLogAndExecute(@NotNull Project project, @NotNull Consumer<? super VcsLogUiImpl> consumer) {
        ToolWindow window;
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(19);
        }
        if (consumer == null) {
            VcsLogContentUtil.$$$reportNull$$$0(20);
        }
        if (!VcsLogContentUtil.selectMainLog(window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID))) {
            VcsBalloonProblemNotifier.showOverChangesView(project, "Vcs Log is not available", MessageType.WARNING, new NamedRunnable[0]);
            return;
        }
        Runnable runConsumer = () -> ((VcsLogContentProvider)ObjectUtils.notNull((Object)VcsLogContentProvider.getInstance(project))).executeOnMainUiCreated(consumer);
        if (!window.isVisible()) {
            window.activate(runConsumer);
        } else {
            runConsumer.run();
        }
    }

    private static boolean selectMainLog(@NotNull ToolWindow window) {
        Content[] contents;
        if (window == null) {
            VcsLogContentUtil.$$$reportNull$$$0(21);
        }
        ContentManager cm = window.getContentManager();
        for (Content content : contents = cm.getContents()) {
            if (!"Log".equals(content.getDisplayName())) continue;
            cm.setSelectedContent(content);
            return true;
        }
        return false;
    }

    public static void renameLogUi(@NotNull Project project, @NotNull VcsLogUiImpl ui2, @NotNull String newName) {
        ToolWindow toolWindow;
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(22);
        }
        if (ui2 == null) {
            VcsLogContentUtil.$$$reportNull$$$0(23);
        }
        if (newName == null) {
            VcsLogContentUtil.$$$reportNull$$$0(24);
        }
        if ((toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS)) == null) {
            return;
        }
        ContentManager manager = toolWindow.getContentManager();
        JComponent component = ContentUtilEx.findContentComponent((ContentManager)manager, c -> ui2 == VcsLogContentUtil.getLogUi(c));
        if (component == null) {
            return;
        }
        ContentUtilEx.renameTabbedContent((ContentManager)manager, (JComponent)component, (String)newName);
    }

    public static void runWhenLogIsReady(@NotNull Project project, final @NotNull BiConsumer<? super VcsProjectLog, ? super VcsLogManager> action) {
        VcsProjectLog log;
        VcsLogManager manager;
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(25);
        }
        if (action == null) {
            VcsLogContentUtil.$$$reportNull$$$0(26);
        }
        if ((manager = (log = VcsProjectLog.getInstance(project)).getLogManager()) != null) {
            action.accept(log, manager);
        } else {
            new Task.Backgroundable(project, "Loading Commits"){
                @Nullable
                private VcsLogManager myLogManager;

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.myLogManager = log.createLog(true);
                }

                public void onSuccess() {
                    if (this.myLogManager != null) {
                        action.accept(log, this.myLogManager);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/impl/VcsLogContentUtil$1", "run"));
                }
            }.queue();
        }
    }

    @NotNull
    public static VcsLogManager getOrCreateLog(@NotNull Project project) {
        VcsProjectLog log;
        VcsLogManager manager;
        if (project == null) {
            VcsLogContentUtil.$$$reportNull$$$0(27);
        }
        if ((manager = (log = VcsProjectLog.getInstance(project)).getLogManager()) == null) {
            manager = (VcsLogManager)ObjectUtils.notNull((Object)log.createLog(true));
        }
        VcsLogManager vcsLogManager = manager;
        if (vcsLogManager == null) {
            VcsLogContentUtil.$$$reportNull$$$0(28);
        }
        return vcsLogManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogContentUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabGroupName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabId";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogContentUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTabId";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLogUi";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelectContent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelect";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectLogUi";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateTabId";
                break;
            }
            case 11: 
            case 28: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "openLogTab";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "closeLogTab";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "openMainLogAndExecute";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "selectMainLog";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "renameLogUi";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "runWhenLogIsReady";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

