/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.commit.AbstractCommitter;
import com.intellij.vcs.commit.AbstractCommitterKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000 E2\u00020\u0001:\u0001EB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rJ\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000200J\b\u00105\u001a\u000203H$J\b\u00106\u001a\u000203H$J\"\u00106\u001a\u0002032\n\u00107\u001a\u0006\u0012\u0002\b\u0003082\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0004J\b\u00109\u001a\u000203H\u0002J\b\u0010:\u001a\u000203H\u0002J\b\u0010;\u001a\u000203H\u0002J\b\u0010<\u001a\u000203H\u0002J\b\u0010=\u001a\u000203H$J\b\u0010>\u001a\u000203H$J\b\u0010?\u001a\u000203H$J\u0016\u0010@\u001a\u0002032\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020CJ\b\u0010D\u001a\u000203H\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0017R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0017R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0017R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150\u00058F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R0\u0010/\u001a$\u0012\f\u0012\n 1*\u0004\u0018\u00010000 1*\u0010\u0012\f\u0012\n 1*\u0004\u0018\u000100000\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/vcs/commit/AbstractCommitter;", "", "project", "Lcom/intellij/openapi/project/Project;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "commitMessage", "", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "handlers", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/vcs/changes/CommitContext;Ljava/util/List;)V", "_exceptions", "", "Lcom/intellij/openapi/vcs/VcsException;", "_failedToCommitChanges", "_feedback", "", "_pathsToRefresh", "Lcom/intellij/openapi/vcs/FilePath;", "getChanges", "()Ljava/util/List;", "getCommitContext", "()Lcom/intellij/openapi/vcs/changes/CommitContext;", "getCommitMessage", "()Ljava/lang/String;", "committingDocuments", "Lcom/intellij/openapi/editor/Document;", "configuration", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "getConfiguration", "()Lcom/intellij/openapi/vcs/VcsConfiguration;", "exceptions", "getExceptions", "failedToCommitChanges", "getFailedToCommitChanges", "feedback", "", "getFeedback", "()Ljava/util/Set;", "getHandlers", "pathsToRefresh", "getPathsToRefresh", "getProject", "()Lcom/intellij/openapi/project/Project;", "resultHandlers", "Lcom/intellij/openapi/vcs/changes/CommitResultHandler;", "kotlin.jvm.PlatformType", "addResultHandler", "", "resultHandler", "afterCommit", "commit", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "delegateCommitToVcsThread", "doRunCommit", "finishCommit", "markCommittingDocuments", "onFailure", "onFinish", "onSuccess", "runCommit", "taskName", "sync", "", "unmarkCommittingDocuments", "Companion", "intellij.platform.vcs.impl"})
public abstract class AbstractCommitter {
    private final List<Document> committingDocuments;
    private final List<CommitResultHandler> resultHandlers;
    private final Set<String> _feedback;
    private final List<Change> _failedToCommitChanges;
    private final List<VcsException> _exceptions;
    private final List<FilePath> _pathsToRefresh;
    @NotNull
    private final VcsConfiguration configuration;
    @NotNull
    private final Project project;
    @NotNull
    private final List<Change> changes;
    @NotNull
    private final String commitMessage;
    @NotNull
    private final CommitContext commitContext;
    @NotNull
    private final List<CheckinHandler> handlers;
    @JvmField
    @NotNull
    public static final Key<Object> DOCUMENT_BEING_COMMITTED_KEY;
    public static final Companion Companion;

    @NotNull
    public final Set<String> getFeedback() {
        return CollectionsKt.toSet((Iterable)this._feedback);
    }

    @NotNull
    public final List<Change> getFailedToCommitChanges() {
        return CollectionsKt.toList((Iterable)this._failedToCommitChanges);
    }

    @NotNull
    public final List<VcsException> getExceptions() {
        return CollectionsKt.toList((Iterable)this._exceptions);
    }

    @NotNull
    public final List<FilePath> getPathsToRefresh() {
        return CollectionsKt.toList((Iterable)this._pathsToRefresh);
    }

    @NotNull
    public final VcsConfiguration getConfiguration() {
        return this.configuration;
    }

    public final void addResultHandler(@NotNull CommitResultHandler resultHandler) {
        Intrinsics.checkParameterIsNotNull((Object)resultHandler, (String)"resultHandler");
        Collection collection = this.resultHandlers;
        boolean bl = false;
        collection.add(resultHandler);
    }

    public final void runCommit(@NotNull String taskName, boolean sync) {
        Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
        Task.Backgroundable task2 = new Task.Backgroundable(this, sync, taskName, this.project, taskName, true, this.configuration.getCommitOption()){
            final /* synthetic */ AbstractCommitter this$0;
            final /* synthetic */ boolean $sync;
            final /* synthetic */ String $taskName;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
                vcsManager.startBackgroundVcsOperation();
                try {
                    AbstractCommitter.access$delegateCommitToVcsThread(this.this$0);
                }
                finally {
                    vcsManager.stopBackgroundVcsOperation();
                }
            }

            public boolean shouldStartInBackground() {
                return !this.$sync && super.shouldStartInBackground();
            }

            public boolean isConditionalModal() {
                return this.$sync;
            }
            {
                this.this$0 = $outer;
                this.$sync = $captured_local_variable$1;
                this.$taskName = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
        task2.queue();
    }

    protected abstract void commit();

    protected abstract void afterCommit();

    protected abstract void onSuccess();

    protected abstract void onFailure();

    protected abstract void onFinish();

    protected final void commit(@NotNull AbstractVcs<?> vcs, @NotNull List<? extends Change> changes2) {
        Intrinsics.checkParameterIsNotNull(vcs, (String)"vcs");
        Intrinsics.checkParameterIsNotNull(changes2, (String)"changes");
        CheckinEnvironment environment = vcs.getCheckinEnvironment();
        if (environment != null) {
            List list = ChangesUtil.getPaths((Collection)changes2);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ChangesUtil.getPaths(changes)");
            this._pathsToRefresh.addAll(list);
            List exceptions = environment.commit(changes2, this.commitMessage, this.commitContext, this._feedback);
            Collection collection = exceptions;
            boolean bl = false;
            boolean bl2 = false;
            if (!(collection == null || collection.isEmpty())) {
                this._exceptions.addAll(exceptions);
                this._failedToCommitChanges.addAll((Collection<Change>)changes2);
            }
        }
    }

    private final void delegateCommitToVcsThread() {
        DelegatingProgressIndicator indicator = new DelegatingProgressIndicator();
        TransactionGuard.getInstance().assertWriteSafeContext(indicator.getModalityState());
        Semaphore endSemaphore = new Semaphore();
        endSemaphore.down();
        ChangeListManagerImpl.getInstanceImpl(this.project).executeOnUpdaterThread(new Runnable(this, indicator, endSemaphore){
            final /* synthetic */ AbstractCommitter this$0;
            final /* synthetic */ DelegatingProgressIndicator $indicator;
            final /* synthetic */ Semaphore $endSemaphore;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                this.$indicator.setText("Performing VCS commit...");
                try {
                    ProgressManager.getInstance().runProcess(new Runnable(this){
                        final /* synthetic */ delegateCommitToVcsThread.1 this$0;

                        public final void run() {
                            this.this$0.$indicator.checkCanceled();
                            AbstractCommitter.access$doRunCommit(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, (ProgressIndicator)this.$indicator);
                }
                finally {
                    this.$endSemaphore.up();
                }
            }
            {
                this.this$0 = abstractCommitter;
                this.$indicator = delegatingProgressIndicator;
                this.$endSemaphore = semaphore;
            }
        });
        indicator.setText("Waiting for VCS background tasks to finish...");
        while (!endSemaphore.waitFor(20L)) {
            indicator.checkCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doRunCommit() {
        try {
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ AbstractCommitter this$0;
                {
                    this.this$0 = abstractCommitter;
                }

                public final T compute() {
                    boolean bl = false;
                    AbstractCommitter.access$markCommittingDocuments(this.this$0);
                    return (T)Unit.INSTANCE;
                }
            });
            try {
                this.commit();
                $i$f$runReadAction = false;
            }
            catch (Throwable $i$f$runReadAction2) {
                boolean $i$f$runReadAction3 = false;
                ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                    final /* synthetic */ AbstractCommitter this$0;
                    {
                        this.this$0 = abstractCommitter;
                    }

                    public final T compute() {
                        boolean bl = false;
                        AbstractCommitter.access$unmarkCommittingDocuments(this.this$0);
                        return (T)Unit.INSTANCE;
                    }
                });
                throw $i$f$runReadAction2;
            }
            ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ AbstractCommitter this$0;
                {
                    this.this$0 = abstractCommitter;
                }

                public final T compute() {
                    boolean bl = false;
                    AbstractCommitter.access$unmarkCommittingDocuments(this.this$0);
                    return (T)Unit.INSTANCE;
                }
            });
            this.afterCommit();
        }
        catch (ProcessCanceledException pce) {
            throw (Throwable)pce;
        }
        catch (Throwable e) {
            AbstractCommitterKt.access$getLOG$p().error(e);
            this._exceptions.add(new VcsException(e));
            ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            this.finishCommit();
            this.onFinish();
        }
    }

    private final void finishCommit() {
        List<VcsException> errors = Companion.collectErrors(this._exceptions);
        boolean noErrors = errors.isEmpty();
        boolean noWarnings = this._exceptions.isEmpty();
        if (noErrors) {
            CheckinHandler it;
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CheckinHandler)element$iv;
                boolean bl = false;
                it.checkinSuccessful();
            }
            this.onSuccess();
            $this$forEach$iv = this.resultHandlers;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CommitResultHandler)element$iv;
                boolean bl = false;
                it.onSuccess(this.commitMessage);
            }
            if (noWarnings) {
                ProgressManager.progress((String)VcsBundle.message((String)"commit.dialog.completed.successfully", (Object[])new Object[0]));
            }
        } else {
            CheckinHandler it;
            Iterable $this$forEach$iv = this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CheckinHandler)element$iv;
                boolean bl = false;
                it.checkinFailed(errors);
            }
            this.onFailure();
            $this$forEach$iv = this.resultHandlers;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CommitResultHandler)element$iv;
                boolean bl = false;
                it.onFailure();
            }
        }
    }

    private final void markCommittingDocuments() {
        this.committingDocuments.addAll(AbstractCommitterKt.access$markCommittingDocuments(this.project, this.changes));
    }

    private final void unmarkCommittingDocuments() {
        AbstractCommitterKt.access$unmarkCommittingDocuments(this.committingDocuments);
        this.committingDocuments.clear();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<Change> getChanges() {
        return this.changes;
    }

    @NotNull
    public final String getCommitMessage() {
        return this.commitMessage;
    }

    @NotNull
    public final CommitContext getCommitContext() {
        return this.commitContext;
    }

    @NotNull
    public final List<CheckinHandler> getHandlers() {
        return this.handlers;
    }

    public AbstractCommitter(@NotNull Project project, @NotNull List<? extends Change> changes2, @NotNull String commitMessage2, @NotNull CommitContext commitContext, @NotNull List<? extends CheckinHandler> handlers) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(changes2, (String)"changes");
        Intrinsics.checkParameterIsNotNull((Object)commitMessage2, (String)"commitMessage");
        Intrinsics.checkParameterIsNotNull((Object)commitContext, (String)"commitContext");
        Intrinsics.checkParameterIsNotNull(handlers, (String)"handlers");
        this.project = project;
        this.changes = changes2;
        this.commitMessage = commitMessage2;
        this.commitContext = commitContext;
        this.handlers = handlers;
        AbstractCommitter abstractCommitter = this;
        boolean bl = false;
        abstractCommitter.committingDocuments = collection = (List)new ArrayList();
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"createLockFreeCopyOnWrit\u2026st<CommitResultHandler>()");
        this.resultHandlers = list;
        abstractCommitter = this;
        bl = false;
        collection = new LinkedHashSet();
        abstractCommitter._feedback = collection;
        abstractCommitter = this;
        bl = false;
        abstractCommitter._failedToCommitChanges = collection = (List)new ArrayList();
        abstractCommitter = this;
        bl = false;
        abstractCommitter._exceptions = collection = (List)new ArrayList();
        abstractCommitter = this;
        bl = false;
        abstractCommitter._pathsToRefresh = collection = (List)new ArrayList();
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsConfiguration, (String)"VcsConfiguration.getInstance(project)");
        this.configuration = vcsConfiguration;
    }

    static {
        Companion = new Companion(null);
        DOCUMENT_BEING_COMMITTED_KEY = new Key("DOCUMENT_BEING_COMMITTED");
    }

    public static final /* synthetic */ void access$delegateCommitToVcsThread(AbstractCommitter $this) {
        $this.delegateCommitToVcsThread();
    }

    public static final /* synthetic */ void access$doRunCommit(AbstractCommitter $this) {
        $this.doRunCommit();
    }

    public static final /* synthetic */ void access$markCommittingDocuments(AbstractCommitter $this) {
        $this.markCommittingDocuments();
    }

    public static final /* synthetic */ void access$unmarkCommittingDocuments(AbstractCommitter $this) {
        $this.unmarkCommittingDocuments();
    }

    @JvmStatic
    @NotNull
    public static final List<VcsException> collectErrors(@NotNull List<? extends VcsException> exceptions) {
        return Companion.collectErrors(exceptions);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/vcs/commit/AbstractCommitter$Companion;", "", "()V", "DOCUMENT_BEING_COMMITTED_KEY", "Lcom/intellij/openapi/util/Key;", "collectErrors", "", "Lcom/intellij/openapi/vcs/VcsException;", "exceptions", "intellij.platform.vcs.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<VcsException> collectErrors(@NotNull List<? extends VcsException> exceptions) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(exceptions, (String)"exceptions");
            Iterable $this$filterNot$iv = exceptions;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                VcsException it = (VcsException)((Object)element$iv$iv);
                boolean bl = false;
                if (it.isWarning()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

