/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.ColorButtonBase;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorSelectionComponent
extends JPanel {
    private static final String CUSTOM_COLOR_NAME = "Custom";
    private final Map<String, ColorButton> myColorToButtonMap = new LinkedHashMap<String, ColorButton>();
    private final ButtonGroup myButtonGroup = new ButtonGroup();
    private ChangeListener myChangeListener;

    public ColorSelectionComponent() {
        super(new GridLayout(1, 0, 5, 5));
        this.setOpaque(false);
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.myChangeListener = changeListener;
    }

    public void setSelectedColor(String colorName) {
        AbstractButton button2 = this.myColorToButtonMap.get(colorName);
        if (button2 != null) {
            button2.setSelected(true);
        }
    }

    @NotNull
    public Collection<String> getColorNames() {
        Set<String> set = this.myColorToButtonMap.keySet();
        if (set == null) {
            ColorSelectionComponent.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Nullable
    public String getColorName(@Nullable Color color) {
        if (color == null) {
            return null;
        }
        for (String name : this.myColorToButtonMap.keySet()) {
            if (color.getRGB() != this.myColorToButtonMap.get(name).getColor().getRGB()) continue;
            return name;
        }
        return null;
    }

    public void addCustomColorButton() {
        CustomColorButton customButton = new CustomColorButton();
        this.myButtonGroup.add(customButton);
        this.add(customButton);
        this.myColorToButtonMap.put(customButton.getText(), customButton);
    }

    public void addColorButton(@NotNull String name, @NotNull Color color) {
        if (name == null) {
            ColorSelectionComponent.$$$reportNull$$$0(1);
        }
        if (color == null) {
            ColorSelectionComponent.$$$reportNull$$$0(2);
        }
        ColorButton colorButton = new ColorButton(name, color);
        this.myButtonGroup.add(colorButton);
        this.add(colorButton);
        this.myColorToButtonMap.put(name, colorButton);
    }

    public void setCustomButtonColor(@NotNull Color color) {
        if (color == null) {
            ColorSelectionComponent.$$$reportNull$$$0(3);
        }
        CustomColorButton button2 = (CustomColorButton)this.myColorToButtonMap.get(CUSTOM_COLOR_NAME);
        button2.setColor(color);
        button2.setSelected(true);
        button2.repaint();
    }

    @Nullable
    public String getSelectedColorName() {
        for (String name : this.myColorToButtonMap.keySet()) {
            ColorButton button2 = this.myColorToButtonMap.get(name);
            if (!button2.isSelected()) continue;
            if (button2 instanceof CustomColorButton) {
                String color = ColorUtil.toHex((Color)button2.getColor());
                String colorName = FileColorManagerImpl.getColorName(button2.getColor());
                return colorName == null ? color : colorName;
            }
            return name;
        }
        return null;
    }

    public void initDefault(@NotNull FileColorManager manager, @Nullable String selectedColorName) {
        if (manager == null) {
            ColorSelectionComponent.$$$reportNull$$$0(4);
        }
        for (String name : manager.getColorNames()) {
            this.addColorButton(name, (Color)ObjectUtils.assertNotNull((Object)manager.getColor(name)));
        }
        this.addCustomColorButton();
        this.setSelectedColor(selectedColorName);
    }

    public void stateChanged() {
        if (this.myChangeListener != null) {
            this.myChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/ColorSelectionComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/ColorSelectionComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addColorButton";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCustomButtonColor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CustomColorButton
    extends ColorButton {
        private CustomColorButton() {
            super(ColorSelectionComponent.CUSTOM_COLOR_NAME, (Color)JBColor.WHITE);
            this.myColor = null;
        }

        @Override
        protected void doPerformAction(ActionEvent e) {
            Color color = ColorChooser.chooseColor((Component)this, (String)"Choose Color", (Color)this.myColor);
            if (color != null) {
                this.myColor = color;
            }
            this.setSelected(this.myColor != null);
            ColorSelectionComponent.this.stateChanged();
        }

        @Override
        protected ButtonUI createUI() {
            return new ColorButtonBase.ColorButtonUI(){

                @Override
                @Nullable
                protected Color getUnfocusedBorderColor(@NotNull ColorButtonBase button2) {
                    if (button2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (UIUtil.isUnderDarcula()) {
                        return JBColor.GRAY;
                    }
                    return super.getUnfocusedBorderColor(button2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/ui/tabs/ColorSelectionComponent$CustomColorButton$1", "getUnfocusedBorderColor"));
                }
            };
        }

        @Override
        public Color getForeground() {
            return this.getModel().isSelected() ? JBColor.BLACK : JBColor.GRAY;
        }

        @Override
        @NotNull
        Color getColor() {
            Object object = this.myColor == null ? JBColor.WHITE : this.myColor;
            if (object == null) {
                CustomColorButton.$$$reportNull$$$0(0);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/ColorSelectionComponent$CustomColorButton", "getColor"));
        }
    }

    private class ColorButton
    extends ColorButtonBase {
        protected ColorButton(String text2, Color color) {
            super(text2, color);
        }

        @Override
        protected void doPerformAction(ActionEvent e) {
            ColorSelectionComponent.this.stateChanged();
        }
    }
}

