/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.remote.CredentialsType;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;

public abstract class LanguageCaseCollector<T> {
    public CredentialsCase[] collectCases(Class<T> languageContributionClass, CredentialsCase ... cases) {
        ArrayList<1> exCases = new ArrayList<1>();
        for (final CredentialsLanguageContribution contribution : (CredentialsLanguageContribution[])CredentialsLanguageContribution.EP_NAME.getExtensions()) {
            if (contribution.getLanguageContributionClass() != languageContributionClass) continue;
            exCases.add(new CredentialsCase(){

                public CredentialsType getType() {
                    return contribution.getType();
                }

                public void process(Object credentials) {
                    LanguageCaseCollector.this.processLanguageContribution(contribution, credentials);
                }
            });
        }
        return (CredentialsCase[])ArrayUtil.mergeArrays((Object[])cases, (Object[])exCases.toArray(new CredentialsCase[0]));
    }

    protected abstract void processLanguageContribution(T var1, Object var2);
}

