/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.FilteredQuery;
import org.jetbrains.annotations.Nullable;

public class ResourceFileUtil {
    private ResourceFileUtil() {
    }

    @Nullable
    public static VirtualFile findResourceFileInDependents(Module searchFromModule, String fileName2) {
        return ResourceFileUtil.findResourceFileInScope(fileName2, searchFromModule.getProject(), searchFromModule.getModuleWithDependenciesScope());
    }

    @Nullable
    public static VirtualFile findResourceFileInProject(Project project, String resourceName) {
        return ResourceFileUtil.findResourceFileInScope(resourceName, project, GlobalSearchScope.projectScope((Project)project));
    }

    @Nullable
    public static VirtualFile findResourceFileInScope(String resourceName, Project project, GlobalSearchScope scope) {
        int index = resourceName.lastIndexOf(47);
        String packageName = index >= 0 ? resourceName.substring(0, index).replace('/', '.') : "";
        String fileName2 = index >= 0 ? resourceName.substring(index + 1) : resourceName;
        VirtualFile dir = (VirtualFile)new FilteredQuery(DirectoryIndex.getInstance(project).getDirectoriesByPackageName(packageName, false), file2 -> {
            VirtualFile child2 = file2.findChild(fileName2);
            return child2 != null && scope.contains(child2);
        }).findFirst();
        return dir != null ? dir.findChild(fileName2) : null;
    }
}

