/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.CommonBundle;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.BinaryMergeRequest;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryMergeRequestImpl
extends BinaryMergeRequest {
    private static final Logger LOG = Logger.getInstance(BinaryMergeRequestImpl.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileContent myFile;
    @NotNull
    private final List<DiffContent> myContents;
    @NotNull
    private final List<byte[]> myByteContents;
    @NotNull
    private final byte[] myOriginalContent;
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<String> myTitles;

    public BinaryMergeRequestImpl(@Nullable Project project, @NotNull FileContent file2, @NotNull byte[] originalContent, @NotNull List<DiffContent> contents, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles) {
        if (file2 == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(0);
        }
        if (originalContent == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(1);
        }
        if (contents == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(2);
        }
        if (byteContents == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(3);
        }
        if (contentTitles == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(4);
        }
        assert (byteContents.size() == 3);
        assert (contents.size() == 3);
        assert (contentTitles.size() == 3);
        this.myProject = project;
        this.myFile = file2;
        this.myOriginalContent = originalContent;
        this.myByteContents = byteContents;
        this.myContents = contents;
        this.myTitle = title;
        this.myTitles = contentTitles;
        this.onAssigned(true);
    }

    @NotNull
    public FileContent getOutputContent() {
        FileContent fileContent = this.myFile;
        if (fileContent == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(5);
        }
        return fileContent;
    }

    @NotNull
    public List<DiffContent> getContents() {
        List<DiffContent> list2 = this.myContents;
        if (list2 == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public List<byte[]> getByteContents() {
        List<byte[]> list2 = this.myByteContents;
        if (list2 == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public List<String> getContentTitles() {
        List<String> list2 = this.myTitles;
        if (list2 == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public void applyResult(@NotNull MergeResult result2) {
        if (result2 == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(9);
        }
        try {
            byte[] applyContent;
            switch (result2) {
                case CANCEL: {
                    applyContent = MergeUtil.shouldRestoreOriginalContentOnCancel((MergeRequest)this) ? this.myOriginalContent : null;
                    break;
                }
                case LEFT: {
                    applyContent = (byte[])ThreeSide.LEFT.select(this.myByteContents);
                    break;
                }
                case RIGHT: {
                    applyContent = (byte[])ThreeSide.RIGHT.select(this.myByteContents);
                    break;
                }
                case RESOLVED: {
                    applyContent = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(result2.toString());
                }
            }
            if (applyContent != null) {
                WriteCommandAction.writeCommandAction(null).run(() -> {
                    try {
                        VirtualFile file2 = this.myFile.getFile();
                        if (!DiffUtil.makeWritable(this.myProject, file2)) {
                            throw new IOException("File is read-only: " + file2.getPresentableName());
                        }
                        file2.setBinaryContent(applyContent);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                        Messages.showErrorDialog((Project)this.myProject, (String)"Can't apply result", (String)CommonBundle.getErrorTitle());
                    }
                });
            }
            MergeCallback.getCallback((MergeRequest)this).applyResult(result2);
        }
        finally {
            this.onAssigned(false);
        }
    }

    private void onAssigned(boolean assigned) {
        this.myFile.onAssigned(assigned);
        for (DiffContent content2 : this.myContents) {
            content2.onAssigned(assigned);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalContent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteContents";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTitles";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/requests/BinaryMergeRequestImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/requests/BinaryMergeRequestImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputContent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteContents";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTitles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

