/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionToolCmdlineOptionHelpProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.ApplicationInspectionProfileManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.XSLTReportConverter;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.impl.PatchProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class InspectionApplication {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.InspectionApplication");
    public InspectionToolCmdlineOptionHelpProvider myHelpProvider;
    public String myProjectPath;
    public String myOutPath;
    public String mySourceDirectory;
    public String myStubProfile;
    public String myProfileName;
    public String myProfilePath;
    public boolean myRunWithEditorSettings;
    public boolean myRunGlobalToolsOnly;
    private int myVerboseLevel;
    public String myOutputFormat;
    public boolean myErrorCodeRequired = true;
    @NonNls
    public static final String DESCRIPTIONS = ".descriptions";
    @NonNls
    public static final String PROFILE = "profile";
    @NonNls
    public static final String INSPECTIONS_NODE = "inspections";
    @NonNls
    public static final String XML_EXTENSION = ".xml";

    public void startup() {
        if (this.myProjectPath == null) {
            InspectionApplication.logError("Project to inspect is not defined");
            this.printHelp();
        }
        if (this.myProfileName == null && this.myProfilePath == null && this.myStubProfile == null) {
            InspectionApplication.logError("Profile to inspect with is not defined");
            this.printHelp();
        }
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
        LOG.info("CPU cores: " + Runtime.getRuntime().availableProcessors() + "; ForkJoinPool.commonPool: " + ForkJoinPool.commonPool() + "; factory: " + ForkJoinPool.commonPool().getFactory());
        ApplicationManagerEx.getApplicationEx().setSaveAllowed(false);
        try {
            this.execute();
        }
        catch (Throwable e) {
            LOG.error(e);
            InspectionApplication.logError(e.getMessage());
            this.gracefulExit();
            return;
        }
        if (this.myErrorCodeRequired) {
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
    }

    public void execute() throws Exception {
        ApplicationManager.getApplication().runReadAction(() -> {
            ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
            this.logMessage(1, InspectionsBundle.message((String)"inspection.application.starting.up", (Object[])new Object[]{appInfo.getFullApplicationName() + " (build " + appInfo.getBuild().asString() + ")"}));
            this.logMessageLn(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
            Disposable disposable = Disposer.newDisposable();
            try {
                this.run(FileUtilRt.toSystemIndependentName((String)PathUtil.getCanonicalPath((String)this.myProjectPath)), disposable);
            }
            finally {
                Disposer.dispose((Disposable)disposable);
            }
            return null;
        });
    }

    private void printHelp() {
        assert (this.myHelpProvider != null);
        this.myHelpProvider.printHelpAndExit();
    }

    private void run(@NotNull @SystemIndependent String projectPath, @NotNull Disposable parentDisposable) throws IOException, JDOMException {
        Path resultsDataPath;
        InspectionsReportConverter reportConverter;
        AnalysisScope scope;
        VirtualFile vfsProject;
        if (projectPath == null) {
            InspectionApplication.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            InspectionApplication.$$$reportNull$$$0(1);
        }
        if ((vfsProject = LocalFileSystem.getInstance().findFileByPath(projectPath)) == null) {
            InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.file.cannot.be.found", (Object[])new Object[]{projectPath}));
            this.printHelp();
        }
        this.logMessage(1, InspectionsBundle.message((String)"inspection.application.opening.project", (Object[])new Object[0]));
        if (ConversionService.getInstance().convertSilently(projectPath, this.createConversionListener()).openingIsCanceled()) {
            this.gracefulExit();
            return;
        }
        Project project = ProjectUtil.openOrImport(projectPath, null, false);
        if (project == null) {
            InspectionApplication.logError("Unable to open project");
            this.gracefulExit();
            return;
        }
        Disposer.register((Disposable)parentDisposable, () -> InspectionApplication.closeProject(project));
        ApplicationManager.getApplication().runWriteAction(() -> VirtualFileManager.getInstance().refreshWithoutFileWatcher(false));
        PatchProjectUtil.patchProject(project);
        this.logMessageLn(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        this.logMessage(1, InspectionsBundle.message((String)"inspection.application.initializing.project", (Object[])new Object[0]));
        InspectionProfileImpl inspectionProfile = this.loadInspectionProfile(project);
        if (inspectionProfile == null) {
            return;
        }
        InspectionManagerEx im = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        GlobalInspectionContextImpl context = im.createNewGlobalContext();
        context.setExternalProfile(inspectionProfile);
        im.setProfile(inspectionProfile.getName());
        if (this.mySourceDirectory == null) {
            String scopeName = System.getProperty("idea.analyze.scope");
            NamedScope namedScope = scopeName != null ? NamedScopesHolder.getScope((Project)project, (String)scopeName) : null;
            scope = namedScope != null ? new AnalysisScope((SearchScope)GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope), project) : new AnalysisScope(project);
        } else {
            this.mySourceDirectory = this.mySourceDirectory.replace(File.separatorChar, '/');
            VirtualFile vfsDir = LocalFileSystem.getInstance().findFileByPath(this.mySourceDirectory);
            if (vfsDir == null) {
                InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.directory.cannot.be.found", (Object[])new Object[]{this.mySourceDirectory}));
                this.printHelp();
            }
            PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(vfsDir);
            scope = new AnalysisScope(psiDirectory);
        }
        this.logMessageLn(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        if (!this.myRunWithEditorSettings) {
            this.logMessageLn(1, InspectionsBundle.message((String)"inspection.application.chosen.profile.log.message", (Object[])new Object[]{inspectionProfile.getName()}));
        }
        if ((reportConverter = InspectionApplication.getReportConverter(this.myOutputFormat)) == null && this.myOutputFormat != null && this.myOutputFormat.endsWith(".xsl")) {
            reportConverter = new XSLTReportConverter(this.myOutputFormat);
        }
        if (!(reportConverter != null && reportConverter.useTmpDirForRawData() || this.myOutPath == null)) {
            resultsDataPath = Paths.get(this.myOutPath, new String[0]);
            Files.createDirectories(resultsDataPath, new FileAttribute[0]);
        } else {
            try {
                File tmpDir = FileUtilRt.createTempDirectory((String)INSPECTIONS_NODE, (String)"data", (boolean)false);
                Disposer.register((Disposable)parentDisposable, () -> FileUtil.delete((File)tmpDir));
                resultsDataPath = tmpDir.toPath();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                System.err.println("Cannot create tmp directory.");
                System.exit(1);
                return;
            }
        }
        ArrayList<Path> inspectionsResults = new ArrayList<Path>();
        this.runUnderProgress(project, context, scope, resultsDataPath, inspectionsResults);
        Path descriptionsFile = resultsDataPath.resolve(".descriptions.xml");
        InspectionApplication.describeInspections(descriptionsFile, this.myRunWithEditorSettings ? null : inspectionProfile.getName(), inspectionProfile);
        inspectionsResults.add(descriptionsFile);
        if (reportConverter != null) {
            try {
                reportConverter.convert(resultsDataPath.toString(), this.myOutPath, context.getTools(), ContainerUtilRt.map2List(inspectionsResults, path -> path.toFile()));
            }
            catch (InspectionsReportConverter.ConversionException e) {
                InspectionApplication.logError("\n" + e.getMessage());
                this.printHelp();
            }
        }
    }

    private void runUnderProgress(@NotNull Project project, @NotNull GlobalInspectionContextImpl context, @NotNull AnalysisScope scope, @NotNull Path resultsDataPath, @NotNull List<? super Path> inspectionsResults) {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(2);
        }
        if (context == null) {
            InspectionApplication.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            InspectionApplication.$$$reportNull$$$0(4);
        }
        if (resultsDataPath == null) {
            InspectionApplication.$$$reportNull$$$0(5);
        }
        if (inspectionsResults == null) {
            InspectionApplication.$$$reportNull$$$0(6);
        }
        ProgressManager.getInstance().runProcess(() -> {
            if (!GlobalInspectionContextUtil.canRunInspections(project, false)) {
                this.gracefulExit();
                return;
            }
            context.launchInspectionsOffline(scope, resultsDataPath.toString(), this.myRunGlobalToolsOnly, inspectionsResults);
            this.logMessageLn(1, "\n" + InspectionsBundle.message((String)"inspection.capitalized.done", (Object[])new Object[0]) + "\n");
            if (!this.myErrorCodeRequired) {
                InspectionApplication.closeProject(project);
            }
        }, (ProgressIndicator)new ProgressIndicatorBase(){
            private String lastPrefix = "";
            private int myLastPercent = -1;

            @Override
            public void setText(String text2) {
                if (InspectionApplication.this.myVerboseLevel == 0) {
                    return;
                }
                if (InspectionApplication.this.myVerboseLevel == 1) {
                    String prefix = InspectionApplication.getPrefix(text2);
                    if (prefix == null) {
                        return;
                    }
                    if (prefix.equals(this.lastPrefix)) {
                        InspectionApplication.this.logMessage(1, ".");
                        return;
                    }
                    this.lastPrefix = prefix;
                    InspectionApplication.this.logMessageLn(1, "");
                    InspectionApplication.this.logMessageLn(1, prefix);
                    return;
                }
                if (InspectionApplication.this.myVerboseLevel == 3) {
                    if (!this.isIndeterminate() && this.getFraction() > 0.0) {
                        int percent = (int)(this.getFraction() * 100.0);
                        if (this.myLastPercent == percent) {
                            return;
                        }
                        String prefix = InspectionApplication.getPrefix(text2);
                        this.myLastPercent = percent;
                        String msg = (prefix != null ? prefix : InspectionsBundle.message((String)"inspection.display.name", (Object[])new Object[0])) + " " + percent + "%";
                        InspectionApplication.this.logMessageLn(2, msg);
                    }
                    return;
                }
                InspectionApplication.this.logMessageLn(2, text2);
            }
        });
    }

    private void gracefulExit() {
        if (!this.myErrorCodeRequired) {
            throw new RuntimeException("Failed to proceed");
        }
        System.exit(1);
    }

    private static void closeProject(@NotNull Project project) {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(7);
        }
        if (!project.isDisposed()) {
            ProjectManagerEx.getInstanceEx().forceCloseProject(project, false);
            ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)project));
        }
    }

    @Nullable
    private InspectionProfileImpl loadInspectionProfile(@NotNull Project project) throws IOException, JDOMException {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(8);
        }
        InspectionProfileImpl inspectionProfile = null;
        if (this.myProfileName != null) {
            inspectionProfile = this.loadProfileByName(project, this.myProfileName);
            if (inspectionProfile == null) {
                InspectionApplication.logError("Profile with configured name (" + this.myProfileName + ") was not found (neither in project nor in config directory)");
                this.gracefulExit();
                return null;
            }
            return inspectionProfile;
        }
        if (this.myProfilePath != null) {
            inspectionProfile = this.loadProfileByPath(this.myProfilePath);
            if (inspectionProfile == null) {
                InspectionApplication.logError("Failed to load profile from '" + this.myProfilePath + "'");
                this.gracefulExit();
                return null;
            }
            return inspectionProfile;
        }
        if (this.myStubProfile != null) {
            if (!this.myRunWithEditorSettings) {
                inspectionProfile = this.loadProfileByName(project, this.myStubProfile);
                if (inspectionProfile != null) {
                    return inspectionProfile;
                }
                inspectionProfile = this.loadProfileByPath(this.myStubProfile);
                if (inspectionProfile != null) {
                    return inspectionProfile;
                }
            }
            inspectionProfile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
            InspectionApplication.logError("Using default project profile");
        }
        return inspectionProfile;
    }

    @Nullable
    private InspectionProfileImpl loadProfileByPath(String profilePath) throws IOException, JDOMException {
        InspectionProfileImpl inspectionProfile = ApplicationInspectionProfileManager.getInstanceImpl().loadProfile(profilePath);
        if (inspectionProfile != null) {
            this.logMessageLn(1, "Loaded profile '" + inspectionProfile.getName() + "' from file '" + profilePath + "'");
        }
        return inspectionProfile;
    }

    @Nullable
    private InspectionProfileImpl loadProfileByName(@NotNull Project project, @NotNull String profileName) {
        InspectionProjectProfileManager profileManager;
        InspectionProfileImpl inspectionProfile;
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(9);
        }
        if (profileName == null) {
            InspectionApplication.$$$reportNull$$$0(10);
        }
        if ((inspectionProfile = (profileManager = InspectionProjectProfileManager.getInstance(project)).getProfile(profileName, false)) != null) {
            this.logMessageLn(1, "Loaded shared project profile '" + profileName + "'");
        } else {
            for (InspectionProfileImpl profile2 : profileManager.getProfiles()) {
                if (!Comparing.strEqual((String)profile2.getName(), (String)profileName)) continue;
                inspectionProfile = profile2;
                this.logMessageLn(1, "Loaded local profile '" + profileName + "'");
                break;
            }
        }
        return inspectionProfile;
    }

    @Nullable
    private static InspectionsReportConverter getReportConverter(@Nullable String outputFormat) {
        for (InspectionsReportConverter converter : (InspectionsReportConverter[])InspectionsReportConverter.EP_NAME.getExtensions()) {
            if (!converter.getFormatName().equals(outputFormat)) continue;
            return converter;
        }
        return null;
    }

    private ConversionListener createConversionListener() {
        return new ConversionListener(){

            @Override
            public void conversionNeeded() {
                InspectionApplication.this.logMessageLn(1, InspectionsBundle.message((String)"inspection.application.project.has.older.format.and.will.be.converted", (Object[])new Object[0]));
            }

            @Override
            public void successfullyConverted(@NotNull File backupDir) {
                if (backupDir == null) {
                    2.$$$reportNull$$$0(0);
                }
                InspectionApplication.this.logMessageLn(1, InspectionsBundle.message((String)"inspection.application.project.was.succesfully.converted.old.project.files.were.saved.to.0", (Object[])new Object[]{backupDir.getAbsolutePath()}));
            }

            @Override
            public void error(@NotNull String message) {
                if (message == null) {
                    2.$$$reportNull$$$0(1);
                }
                InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.cannot.convert.project.0", (Object[])new Object[]{message}));
            }

            @Override
            public void cannotWriteToFiles(@NotNull List<? extends File> readonlyFiles) {
                if (readonlyFiles == null) {
                    2.$$$reportNull$$$0(2);
                }
                StringBuilder files2 = new StringBuilder();
                for (File file2 : readonlyFiles) {
                    files2.append(file2.getAbsolutePath()).append("; ");
                }
                InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.cannot.convert.the.project.the.following.files.are.read.only.0", (Object[])new Object[]{files2.toString()}));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "backupDir";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "readonlyFiles";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/InspectionApplication$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "successfullyConverted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "cannotWriteToFiles";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static String getPrefix(String text2) {
        int idx = text2.indexOf(" in ");
        if (idx == -1) {
            idx = text2.indexOf(" of ");
        }
        return idx == -1 ? null : text2.substring(0, idx);
    }

    public void setVerboseLevel(int verboseLevel) {
        this.myVerboseLevel = verboseLevel;
    }

    private void logMessage(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.print(message);
        }
    }

    private static void logError(String message) {
        System.err.println(message);
    }

    private void logMessageLn(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.println(message);
        }
    }

    private static void describeInspections(@NonNls Path outputPath, @Nullable String name, @NotNull InspectionProfile profile2) throws IOException {
        if (profile2 == null) {
            InspectionApplication.$$$reportNull$$$0(11);
        }
        InspectionToolWrapper[] toolWrappers = profile2.getInspectionTools(null);
        HashMap<String, Set> map2 = new HashMap<String, Set>();
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            String groupName = toolWrapper.getGroupDisplayName();
            Set groupInspections = map2.computeIfAbsent(groupName, __ -> new HashSet());
            groupInspections.add(toolWrapper);
        }
        try (OutputStreamWriter fw = new OutputStreamWriter(Files.newOutputStream(outputPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            PrettyPrintWriter xmlWriter = new PrettyPrintWriter((Writer)fw);
            xmlWriter.startNode(INSPECTIONS_NODE);
            if (name != null) {
                xmlWriter.addAttribute(PROFILE, name);
            }
            for (Map.Entry entry : map2.entrySet()) {
                xmlWriter.startNode("group");
                String groupName = (String)entry.getKey();
                xmlWriter.addAttribute("name", groupName);
                Set entries = (Set)entry.getValue();
                for (InspectionToolWrapper toolWrapper : entries) {
                    xmlWriter.startNode("inspection");
                    String shortName = toolWrapper.getShortName();
                    xmlWriter.addAttribute("shortName", shortName);
                    xmlWriter.addAttribute("displayName", toolWrapper.getDisplayName());
                    boolean toolEnabled = profile2.isToolEnabled(HighlightDisplayKey.find((String)shortName));
                    xmlWriter.addAttribute("enabled", Boolean.toString(toolEnabled));
                    String description = toolWrapper.loadDescription();
                    if (description != null) {
                        xmlWriter.setValue(description);
                    } else {
                        LOG.error(shortName + " descriptionUrl==" + toolWrapper);
                    }
                    xmlWriter.endNode();
                }
                xmlWriter.endNode();
            }
            xmlWriter.endNode();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultsDataPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROFILE;
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/InspectionApplication";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runUnderProgress";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "closeProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "loadInspectionProfile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "loadProfileByName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "describeInspections";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

