/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bootRuntime;

import com.intellij.bootRuntime.ActionPanel;
import com.intellij.bootRuntime.BinTrayUtil;
import com.intellij.bootRuntime.BundleState;
import com.intellij.bootRuntime.Controller$WhenMappings;
import com.intellij.bootRuntime.Model;
import com.intellij.bootRuntime.bundles.Local;
import com.intellij.bootRuntime.bundles.Runtime;
import com.intellij.bootRuntime.command.Cleanup;
import com.intellij.bootRuntime.command.CommandFactory;
import com.intellij.bootRuntime.command.RuntimeCommand;
import com.intellij.bootRuntime.command.UseDefault;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/intellij/bootRuntime/Controller;", "", "project", "Lcom/intellij/openapi/project/Project;", "actionPanel", "Lcom/intellij/bootRuntime/ActionPanel;", "model", "Lcom/intellij/bootRuntime/Model;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/bootRuntime/ActionPanel;Lcom/intellij/bootRuntime/Model;)V", "getActionPanel", "()Lcom/intellij/bootRuntime/ActionPanel;", "getModel", "()Lcom/intellij/bootRuntime/Model;", "getProject", "()Lcom/intellij/openapi/project/Project;", "add", "", "local", "Lcom/intellij/bootRuntime/bundles/Local;", "noRuntimeSelected", "restart", "runtimeSelected", "runtime", "Lcom/intellij/bootRuntime/bundles/Runtime;", "runtimeStateToActions", "", "Lcom/intellij/bootRuntime/command/RuntimeCommand;", "currentState", "Lcom/intellij/bootRuntime/BundleState;", "updateRuntime", "intellij.platform.lang.impl"})
public final class Controller {
    @NotNull
    private final Project project;
    @NotNull
    private final ActionPanel actionPanel;
    @NotNull
    private final Model model;

    public final void updateRuntime() {
        this.runtimeSelected(this.model.getSelectedBundle());
    }

    /*
     * WARNING - void declaration
     */
    public final void runtimeSelected(@NotNull Runtime runtime) {
        Action[] actionArray;
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)runtime, (String)"runtime");
        this.model.updateBundle(runtime);
        this.actionPanel.removeAll();
        List list2 = CollectionsKt.toList((Iterable)this.runtimeStateToActions(runtime, this.model.currentState()));
        Collection collection = list2.subList(1, list2.size());
        Action action2 = (Action)CollectionsKt.firstOrNull((List)list2);
        boolean $i$f$toTypedArray = false;
        void v0 = $this$toTypedArray$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v0;
        Action[] actionArray2 = thisCollection$iv.toArray(new Action[0]);
        if (actionArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Action[] actionArray3 = actionArray = actionArray2;
        Action action3 = action2;
        JBOptionButton job2 = new JBOptionButton(action3, actionArray3);
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.insets = new Insets(0, 0, 0, 0);
        constraint.weightx = 1.0;
        constraint.anchor = 17;
        JButton resetButton = new JButton(new UseDefault(this.project, this));
        resetButton.setToolTipText("Reset boot Runtime to the default one");
        resetButton.setEnabled(BinTrayUtil.getJdkConfigFilePath().exists());
        this.actionPanel.add((Component)resetButton, constraint);
        JButton cleanButton = new JButton(new Cleanup(this.project, this));
        cleanButton.setToolTipText("Remove all installed runtimes");
        this.actionPanel.add((Component)cleanButton, constraint);
        constraint.anchor = 13;
        JRootPane jRootPane = this.actionPanel.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton((JButton)job2);
        }
        this.actionPanel.add((Component)job2, constraint);
        this.actionPanel.repaint();
        this.actionPanel.revalidate();
    }

    private final List<RuntimeCommand> runtimeStateToActions(Runtime runtime, BundleState currentState) {
        List list2;
        switch (Controller$WhenMappings.$EnumSwitchMapping$0[currentState.ordinal()]) {
            case 1: {
                list2 = CollectionsKt.listOf((Object[])new RuntimeCommand[]{CommandFactory.produce(CommandFactory.Type.REMOTE_INSTALL, runtime), CommandFactory.produce(CommandFactory.Type.DOWNLOAD, runtime)});
                break;
            }
            case 2: {
                list2 = CollectionsKt.listOf((Object[])new RuntimeCommand[]{CommandFactory.produce(CommandFactory.Type.INSTALL, runtime), CommandFactory.produce(CommandFactory.Type.DELETE, runtime)});
                break;
            }
            case 3: {
                list2 = CollectionsKt.listOf((Object[])new RuntimeCommand[]{CommandFactory.produce(CommandFactory.Type.INSTALL, runtime), CommandFactory.produce(CommandFactory.Type.DELETE, runtime)});
                break;
            }
            case 4: {
                list2 = CollectionsKt.listOf((Object[])new RuntimeCommand[]{CommandFactory.produce(CommandFactory.Type.INSTALL, runtime), CommandFactory.produce(CommandFactory.Type.DELETE, runtime)});
                break;
            }
            case 5: {
                list2 = CollectionsKt.listOf((Object)CommandFactory.produce(CommandFactory.Type.UNINSTALL, runtime));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    public final void add(@NotNull Local local) {
        Intrinsics.checkParameterIsNotNull((Object)local, (String)"local");
        this.model.getBundles().add(local);
        this.model.setSelectedBundle(local);
    }

    public final void restart() {
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ Controller this$0;

            public final void run() {
                SwingUtilities.getWindowAncestor(this.this$0.getActionPanel()).dispose();
                ApplicationManagerEx.getApplicationEx().restart(true);
            }
            {
                this.this$0 = controller;
            }
        });
    }

    public final void noRuntimeSelected() {
        JBIterable jBIterable = UIUtil.uiTraverser((Component)this.actionPanel).filter(JButton.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"UIUtil.uiTraverser(actio\u2026lter(JButton::class.java)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JButton b = (JButton)element$iv;
            boolean bl = false;
            JButton jButton = b;
            Intrinsics.checkExpressionValueIsNotNull((Object)jButton, (String)"b");
            jButton.setEnabled(false);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ActionPanel getActionPanel() {
        return this.actionPanel;
    }

    @NotNull
    public final Model getModel() {
        return this.model;
    }

    public Controller(@NotNull Project project, @NotNull ActionPanel actionPanel, @NotNull Model model2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)actionPanel, (String)"actionPanel");
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        this.project = project;
        this.actionPanel = actionPanel;
        this.model = model2;
        CommandFactory.initialize(this.project, this);
    }
}

